# $Id: Makefile.PL 1 2006-11-14 08:18:15Z rcaputo $

use warnings;
use strict;

use ExtUtils::MakeMaker;

### Touch files that will be generated at "make dist" time.
### ExtUtils::MakeMaker and Module::Build will complain about them if
### they aren't present now.

open(TOUCH, ">>CHANGES") and close TOUCH;
open(TOUCH, ">>META.yml") and close TOUCH;

### Generate Makefile.PL.

WriteMakefile(
	NAME => 'Lexical::Persistence',
	AUTHOR => 'Rocco Caputo <rcaputo@cpan.org>',
	ABSTRACT => 'Persistent, continuation-like contexts for lexical variables.',
  VERSION_FROM => 'lib/Lexical/Persistence.pm',
	LICENSE => 'perl',
  dist           => {
    COMPRESS => 'gzip -9f',
    SUFFIX   => 'gz',
    PREOP    => (
      '../repo-tools/svn-log.perl | ' .
      '/usr/bin/tee ./$(DISTNAME)-$(VERSION)/CHANGES > ./CHANGES;'
    ),
  },

  PREREQ_PM => {
		'Devel::LexAlias' => 0.04,
		'PadWalker' => 1.1,
	},
);

1;
