package Forms::Langues_rdb;

use strict;
use warnings;
use Data::Dumper;
use base qw(Wx::App);
use Wx::Perl::DbLinker::Wxform;
use Gtk2::Ex::DbLinker::RdbDataManager;
use Rdb::Speak::Manager;
use Rdb::Country::Manager;

use Log::Log4perl;

use Wx_dnav;
use Forms::Sflang_rdb;

sub new {

    my ( $class, $href ) = @_;
    my $self = $class->SUPER::new();
    $self->{xrcfolder} = $$href{xrcfolder};
    $self->{dbh}       = $$href{dbh};
    $self->{log}       = Log::Log4perl->get_logger(__PACKAGE__);
    $self->{dnav}      = Wx_dnav->new(
        {
            size      => [ 900, 900 ],
            main_name => 'mainwindow',
            main_file => '../xrc/main.xrc',
            dbh       => $self->{dbh},
            mibuilder => sub    { $self->get_datamanager_formenuitems(@_); },
        }

    );
    $self->{dnav}->load_panel( 'mainwindow', 'xrc/nav.xrc', 'm_dnav_panel' );

    my $path = $self->{xrcfolder} . "\\content.xrc";
    my $top_panel =
      $self->{dnav}->load_panel( 'm_panel_for_content', $path, 'm_panel1' );

    $self->{log}->debug(" new form ");

    $self->{dnav}
      ->populate_widgets( $self->{dnav}->get_object("m_panel_for_buttons"),
        [qw(b_apply)] );

    my $data = Rdb::Country::Manager->get_countries( sort_by => 'country' );

    my $dman = Gtk2::Ex::DbLinker::RdbDataManager->new(
        data => $data,
        meta => Rdb::Country->meta,

    );

    $self->{linker} = Wx::Perl::DbLinker::Wxform->new(
        data_manager        => $dman,
        builder             => $self->{dnav},
        rec_spinner         => $self->{dnav}->get_object('RecordSpinner'),
        status_label        => $self->{dnav}->get_object('lbl_RecordStatus'),
        rec_count_label     => $self->{dnav}->get_object("lbl_RecordCount"),
        primary_keys        => ["countryid"],
        datawidgets_changed => {
            countryid => sub {
                on_countryid_changed( $self->{dnav}->get_object('countryid'),
                    $self );
            },
        },
    );

    $self->{dnav}->set_form( $self->{linker} );

    $self->{countryid} = $dman->get_field('countryid');

    my $combodata = Gtk2::Ex::DbLinker::RdbDataManager->new(
        data => Rdb::Langue::Manager->get_langues( sort_by => 'langue' ),
        meta => Rdb::Langue->meta,
    );

    $self->{linker}->add_combo(
        data_manager => $combodata,
        id           => 'mainlangid',
    );

    $self->{sf} = Forms::Sflang_rdb->new(
        xrcfolder => $self->{xrcfolder},
        schema    => $self->{schema},
        dnav      => $self->{dnav},
        panel_to  => 'panel_subform',
        countryid => $self->{countryid},
    );

    $self->{linker}->add_childform( $self->{sf}->{sform} );

    $self->{linker}->update;

    $self->{dnav}->show_all_except( [] );

    $self->{sf}->{dnav}->show_all_except( [] );

    $self->{sf}->{sf_list}->{dnav}->show_all_except( [] );

    return $self;

}

sub OnInit {
    1;
}

sub on_countryid_changed {
    my ( $b, $self ) = @_;
    $self->{log}->debug("countryid_changed called");
    my $value = $b->GetLineText(0);
    $value = ( $value eq "" ? undef : $value );

   #return && $self->{dnav}->widgets_set_sensitivity(0) unless defined ($value);
    if ( defined $value ) {
        $self->{log}->debug("on_countryid_changed : $value");
        $self->{countryid} = $value;
        my $rc = $self->{linker}->get_data_manager->row_count;
        if ( $rc == 0 ) {
            $self->{dnav}->widgets_set_sensitivity(0);
        } else {
            $self->{dnav}->widgets_set_sensitivity(1);
        }
        $self->{sf}->on_countryid_changed($value);
    } else {
        $self->{sf}->on_countryid_changed($value);
        $self->{dnav}->widgets_set_sensitivity(0);
    }
}

sub get_datamanager_formenuitems {
    my $self = shift;

# called as &coderef from wx_dnav $self is not passed and the first element in @_ is the argument passed in the call
    my $href = ( ref $_[0] eq "HASH" ? $_[0] : { (@_) } );
    my %class = (
        countries => 'Rdb::Country',
        langues   => 'Rdb::Langue',
        speakes   => 'Rdb::Speak'
    );
    my $data;
    if ( $href->{name} ) {
        my $classname = $class{ $href->{name} };

        #die $name;
        my $rdbdata =
          Rose::DB::Object::Manager->get_objects( object_class => $classname );
        my $meta = $class{ $href->{name} }->meta;
        $data = Gtk2::Ex::DbLinker::RdbDataManager->new(
            data => $rdbdata,
            meta => $meta
        );

    } else {
        $self->{log}
          ->debug("Displaying result from select query is not implemented");

    }
    return $data;
}

1;
