
package Wx::Perl::DbLinker::Wxform;
use  Wx::Perl::DbLinker;
our $VERSION = $Wx::Perl::DbLinker::VERSION;

use strict;
use warnings;
use Carp  qw(croak confess carp);
use DateTime::Format::Strptime;
use Data::Dumper;

use Wx qw[:everything];
#EVT_DATAVIEW_ITEM_VALUE_CHANGED
use Wx::Event qw[EVT_TEXT EVT_LIST_ITEM_SELECTED EVT_COMBOBOX EVT_LISTBOX &EVT_CHECKBOX EVT_RADIOBUTTON EVT_SPINCTRL  EVT_TEXT_ENTER];

#'Wx::TextCtrl' => \&_get_textbuffer,
#'Wx::Calendar' => 'day_selected',
#'Wx::TextEntry' => 'TextChanged',
#'Wx::DataViewListCtrl' => \&EVT_DATAVIEW_ITEM_VALUE_CHANGED,
#'Wx::ToggleButton' => 'Toggled',

my %signals = (

	'Wx::TextEntry' => \&EVT_TEXT,
	'Wx::ComboBox' => \&EVT_COMBOBOX,
	'Wx::CheckBox' => \&EVT_CHECKBOX,
	'Wx::SpinCtrl' => \&EVT_SPINCTRL,
	'Wx::TextCtrl' => \&EVT_TEXT,
	'Wx::ListCtrl' => \&EVT_LIST_ITEM_SELECTED,
	'Wx::ListBox' => \&EVT_LISTBOX,
	'Wx::RadioButton' => \&EVT_RADIOBUTTON,
);


#
#coderef to place the value of record x in each field, combo, toggle...
#'Wx::DataViewListCtrl' => \&_set_combo,
my %setter = (
	'Wx::TextCtrl' => \&_set_entry,
	'Wx::RadioButton' => \&_set_check,
	'Wx::ComboBox' => \&_set_combo,
	'Wx::CheckBox' => \&_set_check,
	'Wx::SpinButton' => \&_set_spinbutton,
	'Wx::ListCtrl' => \&_set_combo,
	'Wx::ListBox' => \&_set_combo,
	

);

my %getter = (
	 'Wx::TextCtrl' => sub {my ($self, $w, $id) = @_; return $w->GetValue;},
	'Wx::ToggleButton' => sub {my ($self, $w, $id) = @_; return $w->get_active;},
	'Wx::ComboBox' => ,  sub { my ($self, $w, $id) = @_; return $self->_get_combobox_selectedvalue($id)},
	'Wx::ListBox' => ,  sub { my ($self, $w, $id) = @_; return $self->_get_combobox_selectedvalue($id)},
	'Wx::CheckBox' => sub { my ($self,  $w, $id) = @_; return $w->get_active;},
	'Wx::SpinButton' => sub {my ($self, $w, $id) = @_; return $w->get_active;},
	'Wx::ListCtrl' =>   sub{ my ($self, $w, $id) = @_; $self->_get_combobox_selectedvalue($id);},
	
);


sub new {
	my ($class, $req)=@_;
	my $self ={
		dman => $$req{data_manager},
		cols => $$req{datawidgets},
		ecols => $$req{datawidgets_changed}, # a documenter: un hash ref {fieldid1 => coderef, fieldid2 => coderef }
		after_update => $$req{after_update},
		null_string => $$req{null_string} || "null",
		builder => $$req{builder},
		after_insert => $$req{after_insert},
		on_changed => $$req{on_changed},
		rec_spinner => $$req{rec_spinner} || "RecordSpinner",
		status_label => $$req{status_label} || "lbl_RecordStatus",
		rec_count_label => $$req{rec_count_label} || "lbl_RecordCount",
		on_current =>  $$req{on_current},
		date_formatters => $$req{date_formatters},
		datawidgets_ro => $$req{datawidgets_ro},
		time_zone => $$req{time_zone},
		locale => $$req{locale} || 'fr_CH',
		auto_apply =>  (defined $$req{auto_apply} ?  $$req{auto_apply}  : 1),
	
	};
	 bless $self, $class;
	 #$self->{cols} = [];
	 $self->_init;
 	my @dates;

	$self->{subform} = [];

	#my %formatters_db;
	#my %formatters_f;
	 # $self->{dates_formatted} = \(keys %{$self->{date_formatters}});
	foreach my $v ( keys %{$self->{date_formatters}}){
		$self->{log}->debug("** " . $v . " **");
		push @dates, $v;
	}
	 $self->{dates_formatted} = \@dates;
         my %hdates = map {$_ => 1} @dates;
         $self->{hdates_formatted} = \%hdates;
 	$self->{dates_formatters} = {};

 	$self->{pos2del} = [];

	return $self;
  
} #new


sub _init {

	my ($self) = @_;
	$self->{painting}=1;
	# get a ref to the Gtk widget used for the record spinner or if the id has been guiven, get the ref via the builder
	$self->{rec_spinner} =(ref $self->{rec_spinner} ? $self->{rec_spinner} : $self->{builder}->get_object( $self->{rec_spinner} ));
	$self->{rec_count_label} = (ref $self->{rec_count_label} ? $self->{rec_count_label} : $self->{builder}->get_object( $self->{rec_count_label} ));
	$self->{status_label} = (ref $self->{status_label} ?  $self->{status_label} : $self->{builder}->get_object( $self->{status_label} ));

	$self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
	$self->{log}->debug(" ** New Form object ** ");
	$self->{changed} = 0;
	if (! defined $self->{cols}){
		my @col = $self->{dman}->get_field_names;
		$self->{cols} = \@col;
		$self->{log}->debug("_init cols: ".  join(" ", @col));
	}
	$self->{hecols}={};
	if ( defined $self->{ecols}) {
		my %is_ecol;
		my @fields = keys %{$self->{ecols}};
		for (@fields){ $is_ecol{$_}++;}
		$self->{hecols} = \%is_ecol;
		$self->{log}->debug("datawidgets_changed: " . join(" ", @fields));
	
	}
	if  ( defined $self->{datawidgets_ro}){
		my %is_ro;
		for (@{$self->{datawidgets_ro}}){ $is_ro{$_}++;}
		$self->{is_ro} = \%is_ro;
	
	}

	$self->_bind_on_changed;
	$self->_set_recordspinner;
	croak __PACKAGE__ . ": a data manager is required" unless (defined $self->{dman});
	$self->{dman}->set_row_pos(0);
}


sub set_data_manager {
	my ($self, $dman) = @_;
	$self->{dman} = $dman;
}

sub add_childform {
	my ($self, $sf) = @_;
	$self->{log}->warn("add_childform : do not set auto_apply to 0 if you call this method") unless ($self->{auto_apply});
	#carp("add_childform : do not set auto_apply to 0 if you call this method")  unless ($self->{auto_apply});
	push @{$self->{subform}}, $sf;

}


#dman must contains all the rows 
# $self->{datawidgetsValue} contient la valeur selectionnee pour Wx::ListCtrl
# mais pour Wx::ComboBox il contient une ref au hash des id (col 0) et leur position dans le combo
# ClientData ne sert a rien ?
#
#renvoyer un hash de la col 0/index dans tous les cas ?

#add the values contained in the array @$aref in the combo $name
#the combo has to a Wx::ComboBox
#set the hash ref of row# => id in $self->{datawidgetsValue}->{$field}
#set the hash ref of id => row# in $self->{datawidgetsPos}->{$field}

sub add_combo_values {

	my ($self, $w, $aref, $name)=@_;
	# $self->{log}->debug( "build_list $name\n");
	my $wref = ref $w;
	confess ("only Wx::ComboBox supported by add_combo_values") unless ($wref eq "Wx::ComboBox");

	my $size=0;
	if (defined $aref->[0]){$size = scalar (@{$aref->[0]});} else {$aref=[];}
	# die ($size);
	my (@row_val,$i, %ids, %idpos);
	
	# my $lst = Gtk2::ListStore->new(@{ $self->{lists}->{$name}->{glib} });
	my $pos=0;
	 foreach my $row ( @$aref ) {
		 # push @row_val, $lst->append; 
		 #  print "Data: $row->[0]\n";
		 my $display;
		
		 for ($i=0; $i<$size; $i++){ 
			 if ($i == 0) {
				 #push @ids, $row->[$i];
			    $self->{log}->debug("add_combo_values val:" . $row->[$i] . " index: " . $pos);
			     $ids{$i} = $row->[$i];
			     $idpos{$row->[$i]}= $pos;


			 } else {
			 # push @model, $i, $row->[$i];
			  	$display .= $row->[$i] . " ";
		         }
		 }
		 #push @row_val, $display; # if ($pos == $lastcol); 
		 $w->Append($display);
		 $pos++;
	}
	        $self->{datawidgetsValue}->{ $name } = \%ids;
       		$self->{datawidgetsPos}->{ $name } = \%idpos;

}


#set the hash ref of row# => id in $self->{datawidgetsValue}->{$field}
#set the hash ref of id => row# in $self->{datawidgetsPos}->{$field}
#set the combo's datamanager in $self->{comboDman}->{$field}
sub add_combo{
	my ($self, $req)=@_;

	my $combo = {
		dman => $$req{data_manager}, 
		id => $$req{id},
		fields=> $$req{fields},
		init => $$req{init} || 1,

	};

     my $column_no = 0;
     my @cols;
     if ( defined $combo->{fields}) {
		 @cols= @{$combo->{fields}};
	} else {
		@cols =  $combo->{dman}->get_field_names;

	}
	#my @list_def;
    if ( $$req{builder} && (ref $self eq "")){ #static init
	  
	$self = {};
	$self->{builder} = $$req{builder};

	$self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
      
	 my $w = $self->{builder}->get_object($combo->{id});
	 if ($w)   {
		 #my $name = $w->get_name;
		 my $name = ref $w;
		 #$name =~s/::/_/g;
		 $self->{log}->debug("name: " . $name . "  widget->GetName: " . $w->GetName);
 		$self->{datawidgets}->{ $combo->{id} } = $w;
		$self->{datawidgetsName}->{ $combo->{id} }= $name;	
	 } else {
			$self->{log}->debug("cols: " . join(" ", @cols));  
	      confess "no widget found for combo " . $combo->{id};
	 }
    }

    $self->{log}->debug("cols: " . join(" ", @cols));  
    my $w = $self->{datawidgets}->{$combo->{id}};
     confess('no widget found for combo ' . $combo->{id}) unless ($w); 
   	
     $w->Clear;

     #my @col = @{$self->{cols}};
   croak ("no fields found for combo $combo->{id}") unless(@cols);
    my $lastfield = @cols;
    #the column to show is either the first (pos 0) if it's the only column or
    #the first ( and the next ) 
    
    #my $displayedcol = ($lastfield > 1 ? 1 : 0);
    #$w->set_text_column( $displayedcol );
    #my $model = $w->get_model;

  my $column =0;
   my $last;
   
  #Name is the Wx::XXXX kind of object
  my $name = $self->{datawidgetsName}->{ $combo->{id} };
  #my %idpos;
 my $itemCol;

my %ids;
my %idpos;
my @values;
  foreach my $field ( @cols ) {

	  #$allrows[$i]=[];

	if ($name eq "Wx::ListCtrl") {
	     $itemCol = Wx::ListItem->new;
	     $itemCol->SetText($field);
   	      my $size = ($column == 0 ? 0 : 180);
	     $itemCol->SetWidth($size);

	     $w->InsertColumn($column, $itemCol);
	 
	 } #elsif ($name eq "Wx::DataViewListCtrl") {
		 #$w->AppendTextColumn($field);
			   
		 #} 

	  $last = $combo->{dman}->row_count -1 ;
	  # my $currid;
	  #my @allrows;
	  # die $last if ($combo->{id} eq "lstDates");
	 for  (my $i = 0; $i <= $last; $i++) {
		#$row = $d->column_accessor_value_pairs;
		
		$combo->{dman}->set_row_pos($i);
	   	my $value =  $combo->{dman}->get_field($field);
#die $value  if ($combo->{id} eq "lstDates");
		#push @{$allrows[$i]}, $value if ($name eq "Wx::DataViewListCtrl");   
	           
	            if ($column == 0) {
			     $ids{$i} = $value;
			     $idpos{$value}= $i;

			    if ($name eq "Wx::ListCtrl") {
				   $w->InsertStringItem($i, $value);
			   } elsif (! ($name eq "Wx::ComboBox" || $name eq "Wx::ListBox")) {
				   #$idpos{$value}= $i;
				   #$self->{log}->debug("add_combo col 0 index:  $i value: $value");
				   #my $cd = Wx::ClientData($value);
				   #$w->SetClientData($i, $value);
				   #$currid = $value;
				   #die (Dumper $w->GetClientData($i));
				     confess ("add_combo: $name is not supported" );
			      } 
			      #else {$self->{log}->error("add_combo: $name is not supported" ); return;}
			   
	            } else {
		   #my $e = Wx::TextEntry;
		   #$e->AutComplete(Completer);
 		   	#$w->SetItem($index, $column,$value); #ajoute des elements dans la ligne
			
			 if ($name eq "Wx::ListCtrl") {
				   $w->SetItem($i, $column, $value);
				   push @values, $value;
			   } elsif ($name eq "Wx::ComboBox" || $name eq "Wx::ListBox") {
				   #$w->SetString($i, $value);
				   $w->Append($value);
				   #$self->{log}->debug("add_combo col $column index:  $i value: $value");
				   #$self->{log}->debug("add_combo: ". $combo->{id} . " row: $i value: $value");
			   }
		    }
		    #$self->{log}->debug("add combo: column $column index $i value $value cd: ". ($w->GetClientData($i) ? $w->GetClientData($i) : "undef"));		   
        } #for rows
        
	#$column = ($column == 0 ? 1 : 0);
	$column++;
  } #for each fields

       if ($name eq "Wx::ComboBox" || $name eq "Wx::ListBox") { 
	       #$w->SetClientData(@idval);
	       #$self->{datawidgetsValue}->{ $combo->{id} } = \%idpos;
	       $self->{datawidgetsValue}->{ $combo->{id} } = \%ids;
       		$self->{datawidgetsPos}->{ $combo->{id} } = \%idpos;
		my $href =  {fields => $combo->{fields}, dman => $combo->{dman},  };
		$self->{combo}->{ $combo->{id} } = {dman => $combo->{dman}, fields=> \@cols};
	
	} 

	$self->{log}->debug("add_combo: " . $last . " rows added");

	#crase le listener mis dans bind_changed
	#EVT_LIST_ITEM_SELECTED($self->{builder}->get_object('mainwindow'), $w, sub {$self->_on_selected($combo->{id}, @_)});
	if ($combo->{init} && $w->GetWindowStyleFlag & wxTE_PROCESS_ENTER ) {
		$self->{log}->debug("binding text enter for combo " . $combo->{id} );
		EVT_TEXT_ENTER($self->{builder}->frame, $w, sub {$self->_on_combo_newval($combo->{id}, @_)});	
	}
	

#	if ($self->{datawidgetsName}->{$combo->{id}} eq "GtkComboBoxEntry" ){
        if ($self->{datawidgetsName}->{$combo->{id}} eq "Wx::ListCtrl" ){
		#if ( ! $self->{combos_set}->{$combo->{id}} ) {
		#$w->set_text_column( 1 );
		#$self->{combos_set}->{ $combo->{id} } = TRUE;
		  #}
		  # my $entrycompletion = Gtk2::EntryCompletion->new;
		  #$entrycompletion->set_minimum_key_length( 1 );
		  #$entrycompletion->set_model( $model );
		  #$entrycompletion->set_text_column( $displayedcol );
		  #$w->get_child->set_completion( $entrycompletion );
		  $w->GetEditControl->AutoComplete(@values);
	
	}

return \%ids;
} #sub


sub add_radio_button {
	my ($self, $w, $coderef, $caller) = @_;
	my $name = ref $w;
	my $signal = $signals{$name};
	&$signal($w, $w, sub{ &$coderef($caller, $w); });

}

sub _display_data {
	my ($self, $pos ) = @_;
	$self->{log}->debug( "display_data for row at pos " . $pos );

	my $dman = $self->{dman};

	$self->{pos} = $pos;

	$dman->set_row_pos($pos) unless ($pos<0);

	$self->{painting}=1;
	#foreach my $id (keys %{$self->{datawidgets}}){
	foreach my $id (@{$self->{cols}}) {
		
		my $w = $self->{datawidgets}->{$id};
		my $name = $self->{datawidgetsName}->{$id};
		#die("no name found $id") unless($name);
		#if $name is not defined means that $id is in a field array but with no corresponding 
		#control in the gui
		next unless($name);
		my $x;
		#my $row = $self->{data}[$pos];
	
		if ($pos < 0) {
			$x= undef;	
		} else {
			#$x = $row->$id() if ($row);
			$x = $dman->get_field($id);
			my $ref = ref $x;
			$self->{log}->debug("ref: " . $ref) if ($ref);
					if ($ref && $ref eq "ARRAY") {
					
						# my @set = $row->$id(); 
						#my @set = $dman->get_field($id);
						my @set = @$x;
						$x = join(',', @set);
						$self->{log}->debug( "id: " . $id . " gtkname : " . $name . " ref value: " . ($x?ref($x):"") .  " value: " . ($x?$x:"") . " type : ". $self->{dman}->get_field_type($id) );

					}

		}
	
		# $w->signal_handler_block()

	
		if ( defined $self->{hdates_formatted}->{$id}) {
			#$x = $self->_dateformatter($self->{date_formatters}->{$id}, $x);
			if ( defined $x){
				#my $ff = $self->{dates_formatters_f}->{$id};
				#my $fdb = $self->{dates_formatters_db}->{$id};
				# $self->{log}->debug("display_data formatted received date: ". $x);
				$x = $self->_format_date(0, $id, $x);


			}
		}

		$setter{$name}($self, $w, $x, $id) if($name && $setter{$name});

		if ($name eq "Wx::ListCtrl"){
			$self->{datawidgetsValue}->{$id} = $x;
		
		}
	} #foreach
	#$self->{pos}= $pos;
   my $first = ($pos < 0 ? 0 : 1);
  
   $self->_set_record_status_label;
   $self->_set_rs_range($first);
   $self->{on_current}() if ($self->{on_current});
   $self->{painting}=0;
   $self->{changed}=0;

}


sub undo{
	my $self = shift;
	 $self->{log}->debug("undo clicked");
	 $self->{changed}=0;
	 $self->{pos2del}= [];
	 $self->_display_data( $self->{pos}  );

	  if ($self->{rec_spinner}){
		#$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
       		$self->{rec_spinner}->SetValue($self->{pos} + 1);
		#$self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );
	}
}

sub insert {
	my $self = shift;
	$self->{log}->debug("insert");
	# my $row = $self->{data}[0]->new;

	#$self->{pos} = $self->{count} + 1;
	#afficher des champs vides
	$self->_display_data(-1);
	#data_manager->new_row is called when apply is cliked
	   if ($self->{rec_spinner}){
		  #	my $last = $self->{dman}->row_count;
		  #$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
        	$self->{rec_spinner}->SetValue(0);
		#$self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );
		 
    
    	} 

}

sub delete {
	my $self = shift;
	$self->{log}->debug("delete at " . $self->{dman}->get_row_pos );
	#$self->next;
	$self->{changed} = 1;
	push @{$self->{pos2del}}, $self->{dman}->get_row_pos;
	$self->_set_record_status_label;


}



sub apply{
	my $self = shift;
	my $row;
	my $done;
	#we are adding a new record if $pos < 0
	$self->{log}->debug("apply: pos : " . $self->{pos} );
	if ($self->{pos}<0){
		#my $class =  $self->{class};
		#$row = $class->new;
		 $self->{dman}->new_row;
			#push @{$self->{data}}, $row;
			 # $self->{count} ++;
		 $self->{log}->debug("New row");
		 # $self->{dman}->set_row_pos($self->{dman}->row_count);
		
	}

	# deleting a (or some) record	
	for my $p (@{$self->{pos2del}}){
		$self->{dman}->set_row_pos($p);
		$self->{dman}->delete;
	}
	$self->{log}->debug("items in pos2del: " . scalar @{ $self->{pos2del} } );
	if (scalar @{$self->{pos2del}}){
		$self->{pos2del} = [];
		$self->{changed} = 0;
		# $self->set_record_status_label;
		$self->{rec_spinner}->SetValue(1) if ($self->{rec_spinner});
		return;
	}
	#updating a new or an existing record
	#foreach widget in the form, get the value from the widget and place it in the field unless it's a primary key 
	#with an autogenerated value
	my @pk;
	$self->{log}->debug("cols: " . join(" ", @{$self->{cols}}));
	foreach my $id (@{$self->{cols}}){
		next if ($self->{is_ro}->{$id});
		if (exists  $self->{datawidgets}->{$id}){
			my $w = $self->{datawidgets}->{$id};
			$self->{log}->debug("id: " . $id  . " ref: " . $self->{datawidgetsName}->{$id});
			my $coderef = $getter{ $self->{datawidgetsName}->{$id} };
			  my  $v  = &$coderef($self, $w, $id );
			$self->{log}->debug("apply id: $id value: ".  ($v?$v:""));

			@pk = $self->{dman}->get_autoinc_primarykeys;

			#if ($id ~~ @pk)  {
			if (grep /^$id$/, @pk) {
				$self->{log}->debug("not done because it's a auto incremented pk");
			} else {
		
				$v = ($v eq "" ? undef : $v);
				$self->{log}->debug($id  . ": value undef") unless ( defined $v);	
				# if ( defined $v && ( $id ~~ @{$self->{dates_formatted}})){
				if ( defined $v && defined $self->{hdates_formatted}->{$id}){
					#my $ff = $self->{dates_formatters_f}->{$id};
				
					#my $date = $ff->parse_datetime($v);
					$v = $self->_format_date(1, $id, $v);
				
					# $v = $self->{dates_formatters_db}->{$id}->format_datetime($date);
					#$v = $self->dateformatter('%Y-%m-%d', $date);
				}

				if ($self->{pos} < -1 ) {
					$self->{log}->debug("current row pos: " . $self->{dman}->get_row_pos);
				# $self->{log}->debug("last row pos: " . $self->{dman}->row_count -1);
				# $self->{dman}->set_row_pos($self->{dman}->get_row_count);
					$self->{dman}->set_field($id, $v);
				} else {
			
					$self->{dman}->set_field($id, $v);
				}
				 $self->{log}->debug("done");
			} # not in @pk
	   }	# if exists
	   else {
		$self->{log}->debug($id . " not in data");
	   }
	} #foreach
	#$row->save;
	$done = $self->{dman}->save;
	# $self->{log}->debug("nofm: " . $row->nofm);
	# $self->set_rs_range;

	#if we were adding a row, put it at the end of the array, and display all the values in the form
	#ie the value from the user or default value from the database.
	my %pk_val;	


	for my $pk (@pk) {
		$self->{log}->debug("Primary Key: " . $pk);
		my $value = $self->{dman}->get_field($pk);
		#if (my $ref = eval { $row->can( $pk ) }) {
			#$value = $row->$ref();

			$pk_val{$pk} = $value;
		#}
	}
			#push @pk_val, $id
		
	if ($done && $self->{after_insert}){
		my $coderef = $self->{after_insert};
		&$coderef(undef, \%pk_val );
	}
	if ($done && $self->{pos}<0){
		my $last = $self->{dman}->row_count -1;
		$self->{log}->debug("last is " . $last );
		$self->_display_data( $last );
		 if ($self->{rec_spinner}){
		  #	my $last = $self->{dman}->row_count;
		  #$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
		  	#$self->{rec_spinner}->unsusbscribe('PositionChanged',  $self->{rs_value_changed_signal});
        		$self->{rec_spinner}->SetValue($last+1);
			#$self->{rec_spinner}->subscribe('PositionChanged', $self->{rs_value_changed_signal} );
    		}
       	} else {
		$self->{changed}=0;
	
	}
	if ($done) {
		$self->_save_subforms;

		$self->_set_record_status_label;
	}
	return $done;
}

sub next{
	my $self = shift;
	if ($self->{auto_apply} && $self->has_changed){ $self->apply;}
	$self->_display_data($self->{dman}->next);
}

sub previous {
	my $self = shift;
	if ($self->{auto_apply} && $self->has_changed){ $self->apply;}
	$self->_display_data($self->{dman}->previous);
}
 
sub first{
	my $self = shift;
	if ($self->{auto_apply} && $self->has_changed){ $self->apply;}
	$self->_display_data($self->{dman}->first);
}

sub last {
	my $self = shift;
	if ($self->{auto_apply} && $self->has_changed){ $self->apply;}
	$self->_display_data($self->{dman}->last);
}

sub has_changed {
	my $self = shift;
	my $result= $self->{changed};
	if ($self->{auto_apply}) {
		foreach my $sf (@{$self->{subform}}){
			if ($sf->has_changed){
				$result = 1;
				last;
			} 

		}
	}
	return $result;
}

#bind an onchanged sub with each modification of the datafields
sub _bind_on_changed {
	my $self = shift;
# my @cols = $self->{dman}->get_field_names;
 foreach my $id ( @{$self->{cols}} ){
	 my $w = $self->{builder}->get_object($id);
	 $self->{log}->debug("bind_on_changed looking for widget " . $id);
	 if ($w)   {
		 # my $name = $w->GetName;
		 my $name = ref $w;
		 #$name =~s/::/_/g;
 		$self->{datawidgets}->{$id} = $w;
		$self->{datawidgetsName}->{$id}= $name;

		if ( ref( $signals{$name}) eq "CODE"){
			
			my $coderef = $signals{$name};
			#&$coderef($self->{builder}->get_object('mainwindow'), $w, sub{$self->_changed($id, $w, @_)});
			&$coderef($self->{builder}->frame, $w, sub{$self->_changed($id, $w, @_)});
			#mettre le widget lui meme comme premier arg entraine que la fonction est toujours executee
			#meme si une autre fonction est attachee apres. Si le premier arg est toujours le meme, c'est la derniere
			#fonction attachee qui est executee
			#&$coderef($w, $w, sub{$self->_changed($id, $w, @_)});


		}
		$self->{log}->debug("bind  $name $id with self->changed for signal " . $signals{$name} );
		#$w->signal_connect_after( $signals{$name} => sub{ $self->_changed( $id )});
		die("signal undef for $name") unless($signals{$name});

	} else { $self->{log}->debug(" ... not found ");}
   }
 
}

sub Test {
my ($self, $w) = @_;
print Dumper($w);
#print $w->GetValue. "\n";

}

# Associe une fonction sur value_changed du record_spinner qui appelle move avec abs: valeur lue dans l'etiquette du recordspinner
# Place 
sub _set_recordspinner {
	my $self = shift;
	$self->{log}->debug("set_recordspinner");

    # die unless($self->{rec_spinner});
 my $coderef;
    if ( $self->{rec_spinner} ) {
#	    The return type of the signal_connect() function is a tag that identifies your callback function. 
#	    You may have as many callbacks per signal and per object as you need, and each will be executed in turn, 
#	    in the order they were attached. 
	    #$coderef  = $self->{rec_spinner}->signal_connect_after(	value_changed => sub {
	    $coderef =  sub {
			my $pos = $self->{rec_spinner}->GetValue -1;
		        $self->{log}->debug("rs_value changed will move to " . $pos);	
			#self->{rec_spinner}->signal_handler_block( $coderef );
			#$self->move( undef, $pos);
			if ($self->{auto_apply} && $self->has_changed){ $self->apply;}

			$self->{dman}->set_row_pos($pos);
			$self->_display_data($pos);
			#$self->{rec_spinner}->signal_handler_unblock( $coderef );
			# return 1;
                    };

	    
		EVT_SPINCTRL($self->{rec_spinner}, $self->{rec_spinner}, $coderef);
		EVT_TEXT($self->{rec_spinner}, $self->{rec_spinner}, $coderef);
	      $self->{rs_value_changed_signal}= $coderef;
	      $self->{log}->debug("recordspinner set");
    }

}



sub _set_rs_range {
    my ( $self, $first ) = @_;

    	$self->{log}->debug("set_rs_range  first : " . $first);
	my $rowcount = $self->{dman}->row_count;
    if ( $self->{rec_spinner} ) {
	    # $self->{log}->debug("adj lower : ". $min);
	    # if ($first < $min){ $min = $first;}
	 #$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
	   $self->{rec_spinner}->SetRange( $first, $rowcount );
	#$self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );
    }
    #$self->{rec_count_label}->SetText(" / " . $self->{dman}->row_count);
    #Note that this function will not generate the wxEVT_COMMAND_TEXT_UPDATED event.
    #$self->{rec_count_label}->ChangeValue(" / " . $self->{dman}->row_count);
    $self->{rec_count_label}->SetLabel(" / " . $self->{dman}->row_count);
    return 1;
    
}

sub _set_entry {
	my ($self, $w, $x, $id) = @_;
	if (defined $x){
	$self->{log}->debug("set_entry: " . $x);
		#$w->set_text( $x ) ;
		# SetValue generates a wxEVT_TEXT event. To avoid this you can use ChangeValue() instead.
		#$self->{hecols}->{$id} ? $w->SetValue($x) && $self->{log}->debug("SetValue called") : $w->ChangeValue($x);
		if ($self->{hecols}->{$id}) {
			$w->SetValue($x);
			 #$self->{log}->debug("SetValue called");
		} else {
		 	$w->ChangeValue($x);
			 #$self->{log}->debug("ChangeValue called");
		}
	} else {
		$self->{log}->debug("set_entry: text entry undef " . $w->GetName) ;
		#$w->set_text("");
		$self->{hecols}->{$id} ? $w->Clear : $w->ChangeValue("");
		#$w->ChangeValue("");
	}
	#$self->{log}->debug("hecols : ". ($self->{hecols}->{$id} ? $self->{hecols}->{$id} : "undef") . " for " . $id );

}

sub _set_textentry {
	my ($self, $w, $x, $id) = @_;
 	$self->{log}->debug("set_textentry text entry undef") if (! defined $x);
	$w->get_buffer->set_text($x || "");

}
# DB -> combo
# $x : $value received from the DB
# $id corresponding index
sub _set_combo {
	my ($self, $w, $x, $id) = @_;
	#return unless (defined $x); the combo must be unselect from the preceding value
	my $name = $self->{datawidgetsName}->{$id};
	$self->{log}->debug("set_combo value " . ( defined $x ? $x : " undef") . " widget: ". $name );
	if ($name eq "Wx::ListCtrl") {
		#print "value: $x selected : ", $w->GetSelectedItemCount, "\n";
       
	 	my $item = $w->FindItem(-1, $x);
	
		$w->SetItemState($item, wxLIST_STATE_SELECTED,  wxLIST_STATE_SELECTED);
        } elsif ($name eq "Wx::ComboBox" || $name eq "Wx::ListBox") {
		confess ("undef datawidgetsPos  for ", $id) unless ($self->{datawidgetsPos}->{$id});
		my %idpos = %{ $self->{datawidgetsPos}->{$id} };
		#foreach my $k (keys %idpos) {
		#	$self->{log}->debug("idpos key: ". $k . " value: " . $idpos{$k});
		#}
		#print "keys: ", join(" ", keys (%idpos)), "\n";
		#print "values: ", join(" ", values (%idpos)), "\n";
		# print "value: ", $x, "\n";
		my $i = $idpos{$x};
		$self->{log}->debug("_set_combo pos is " . (defined $i ? $i : " undef") );
		# $w->SetSelection(wxNOT_FOUND);
		if (defined $i) {
			 $w->SetSelection($i);
		 } else {
			 $w->SetSelection(wxNOT_FOUND);
		 }
		 # $self->{log}->debug($w->GetStringSelection);
	
	}
}


sub _set_check {
	my ($self, $w, $x, $id) = @_;
	$w->set_active( $x );
}

#$comboid is the combo id and the field name in the table that received the value selected in the combo
# $field[1] is the name of the field that is displayed in the combo
# $field[0] is the field name of the values returned from the combo
sub _on_combo_newval {
	my ($self, $comboid, $frame, $event) = @_;
	my $value = $event->GetString;
	$self->{log}->debug("combo_newval: " . $value);
	$value = ($value eq "" ? undef : $value);
	return unless (defined $value);
	my $href = $self->{combo}->{$comboid};
	my $dman = $href->{dman};
	my @fields = @{$href->{fields}};
	$dman->new_row;
	$dman->set_field($fields[1], $value);
	$dman->save;
	$self->add_combo({data_manager => $dman, fields=>$href->{fields}, id => $comboid, init=>0});
}

sub _get_combobox_selectedvalue  {
	my ($self, $id) = @_; 

	my $w = $self->{datawidgets}->{$id};
	my $name = $self->{datawidgetsName}->{$id};
	my $x;
	if ($name eq "Wx::ListCtrl") {
		$x=  ($self->{datawidgetsValue}->{$id} ? $self->{datawidgetsValue}->{$id} : undef ); 
	} elsif ($name eq "Wx::ComboBox" || $name eq "Wx::ListBox") {
	
		my $pos = $w->GetSelection();

		$x = ($pos ==  wxNOT_FOUND ) ? undef : $self->{datawidgetsValue}->{$id}->{$pos};
		#my $cd = $w->GetClientData($pos) unless ($pos ==  wxNOT_FOUND);
		$self->{log}->debug("_get_combobox_selectedvalue pos: $pos");
		#return $cd->GetData();
	}
	$self->{log}->debug("_get_combobox_selectedvalue: found $x ");
	return $x;
}


sub _set_spinbutton {
	my ($self, $w, $x) = @_;
	if ($self->getID($w) eq $self->getID($self->{rec_spinner})) {$self->{log}->debug("Found record_spinner... leaving"); return;}
	$w->SetValue( $x || 0 );


}

sub _get_textbuffer {
	my ($self, $w) = @_;
	return $w->get_buffer;

	
}

sub _changed {
	 my ( $self, $fieldname, $w, $frame, $event ) = @_;
	
	 #my $name = ref $w;
	 my $name = $self->{datawidgetsName}->{$fieldname};
	  $self->{log}->debug("self->changed for $fieldname ($name)");
	 if ($name eq "Wx::ListCtrl"){
		print "text: " , $event->GetText, "Index: ", $event->GetIndex, "Data: ", $event->GetData, "\n";
		$self->{datawidgetsValue}->{$fieldname} =  $event->GetText;
		
	}
	if ($self->{hecols}->{$fieldname}) {
		my $coderef = $self->{ecols}->{$fieldname};
		&$coderef($w, $event);

	}
	if (! $self->{painting}){
	    $self->{changed}=1;
	     if ( $self->{on_changed} ) {
                $self->{on_changed}();
            }
	    $self->_set_record_status_label;
    	}
	return 0;


}

sub _on_selected {
	my ($self, $id, $list, $event) = @_;
	#print Dumper $self;
	#print "_on_selected: name: ", ref $list, "\n";
	#print "text: " , $event->GetText, "Index: ", $event->GetIndex, "Data: ", $event->GetData, "\n";
	if ($self->{datawidgetsName}->{$id} eq "Wx::ListCtrl") {
		$self->{datawidgetsValue}->{$id} =  $event->GetText;
	} else {
		croak("_on_selected not implemented for $id ("  . $self->{datawidgetsName}->{$id} . ")");
	}
	
}

sub _save_subforms {
	my ($self) = @_;
	return unless ($self->{auto_apply});
	foreach my $sf (@{$self->{subform}}){
		$sf->apply if ($sf->has_changed);
	}

}
sub _set_record_status_label {

    my $self = shift;
    
    # $self->{log}->debug("set_record_satus_label changed is " . $self->{changed});
    
    if ( $self->{status_label} ) {
        if ( $self->{data_lock} ) {
             $self->{status_label}->SetLabel( "Locked" );
        } elsif ($self->{changed}) {
			  
            $self->{status_label}->SetLabel( "Changed" );
            
	} else {
            $self->{status_label}->SetLabel( "Synchronized" );
        }
    }
}

sub set_widget_value {
	my ($self, $wid, $x) = @_;
	$self->{log}->debug("set_widget_value: " . $wid . " to " . (defined $x ? $x : "null")); 
	my $w = $self->{builder}->get_object($wid);
	if ($w) {
		my $coderef = $setter{ $self->{datawidgetsName}->{$wid} };
		&$coderef($self, $w, $x, $wid ); 
	}

}

sub get_widget_value {
	my ($self, $wid) = @_;
	my $x;
	$self->{log}->debug("get_widget_value: " . $wid);
	my $w = $self->{builder}->get_object($wid);
	$self->{log}->debug("no widget found") unless ($w);
	if ($w && $self->{datawidgetsName}) {
		my $coderef = $getter{ $self->{datawidgetsName}->{$wid} };
		$x  = &$coderef($self, $w, $wid ); 
	}
	$self->{log}->debug("found: " . ($x ? $x : " undef"));
	return ($x ? $x: "");
}


sub update{
	my ($self) =  @_;
	#$self->{log}->debug("update");
	my @col = $self->{dman}->get_field_names;
	$self->{log}->debug("update cols are " . (@col ? join(" " , @col) : " cols undef "));
	if ( $self->{dman}->row_count > 0) {
		$self->_display_data(0); 
	} else {
		$self->_display_data(-1)
	}
	if (defined $self->{after_update}){ 
		$self->{after_update}();
	}
}

#parameter $in_db is 0 or 1 : 
# 0 we are reading from the db, and the format to use are at the pos 0 and 1 in the array of format for the field
# 1 we are writing to the db and the format are to use in a revers order
# $id is the field id
# $v the date string from the form (if in_db is 1) or from the db (if in_db is 0)
sub _format_date{
	my ($self, $in_db, $id,  $v) = @_;
	$self->{log}->debug("format_date received date: ". $v);
	my ($pos1, $pos2 ) = ( $in_db ? (1, 0) : (0, 1));
	my $format =  $self->{date_formatters}->{$id}->[$pos1];
	my $f = $self->_get_dateformatter($format);
	my $dt = $f->parse_datetime($v) or croak($f->errmsg);
	$self->{log}->debug("format_date:  date time object ymd: " . $dt->ymd);
	$format = $self->{date_formatters}->{$id}->[$pos2];
	$f = $self->_get_dateformatter($format);
	my $r = $f->format_datetime($dt)  or croak($f->errmsg);
	$self->{log}->debug("format_date formatted date: ". $r);

	return $r;	

	
}
# create a formatter if none is found in the hash for the corresponding formatting string and store it for later use, and return it or
# return an existing formatter 
sub _get_dateformatter {
	my ($self, $format) = @_;
	my %hf = %{$self->{dates_formatters}};
	my $f;
	if (exists $hf{$format}){
		$self->{log}->debug("get_dateformatter : return an existing formatter for " . $format);
		$f = $hf{$format};
	} else {
		$self->{log}->debug("get_dateformatter: new formatter for " . $format);
		$f = new DateTime::Format::Strptime(
                             pattern         => $format,
                                locale      => $self->{locale},
                                time_zone       => $self->{time_zone},
                                on_error        =>'undef',
                        );  
		$hf{$format} = $f;
	
	}
	$self->{dates_formatters} = \%hf;
	return $f;
}

sub get_data_manager{
	return shift->{dman};
}

1;

__END__

=head1 NAME

Wx::Perl::DbLinker::Wxform - a module that display data from a database in a Wx widgets user interface described in a xrc file.

=head1 VERSION

See Version in L<Wx::Perl::DbLinker>

=head1 SYNOPSIS

	use Rdb::Coll::Manager;
	use Rdb::Biblio::Manager;

	use Gtk2::Ex::DbLinker::RdbDataManager;
	use Wx::Perl::DbLinker::Wxform;

	use Wx qw[:everything];
	use Wx::XRC;

	 $self->{xrc} = Wx::XmlResource->new();
	 $self->{xrc}->InitAllHandlers();
         $self->{xrc}->Load($path_to_xrc_file) or die(....);

	 $self->{frame} = $self->{xrc}->LoadFrame(undef, 'mainwindow'});



This gets the Rose::DB::Object::Manager (we could have use plain sql command, or DBIx::Class object instead), and the DataManager object we pass to the form constructor.

	my $data = Rdb::Mytable::Manager->get_mytable(query => [pk_field => {eq => $value]);

	my $dman = Gtk2::Ex::DbLinker::RdbDataManager->new({data=> $data, meta => Rdb::Mytable->meta });

This create the form.

		$self->{form_coll} = Wx::Perl::DbLinker::Wxform->new({
			data_manager => $dman,
			builder => 	$builder,
		  	rec_spinner => $self->{dnav}->get_object('RecordSpinner'),
	    		status_label=>  $self->{dnav}->get_object('lbl_RecordStatus'),
			rec_count_label => $self->{dnav}->get_object("lbl_recordCount"),
			on_current =>  sub {on_current($self)},
			date_formatters => {
				field_id1 => ["%Y-%m-%d", "%d-%m-%Y"], 
				field_id2 => ["%Y-%m-%d", "%d-%m-%Y"], },
			time_zone => 'Europe/Zurich',
			locale => 'fr_CH',
	    });

C<$builder> is an object that has a C<get_object($name)> method described below and frame method that return the main frame.

C<rec_spinner>, C<status_label>, C<rec_count_label> are Gtk2 widget used to display the position of the current record. See one of the example 2 files in the examples folder for more details. 
C<date_formatters> receives a hash of id for the Gtk2::Entries in the Glade file (keys) and an arrays (values) of formating strings.

In this array

=over

=item *

pos 0 is the date format of the database.

=item * 

pos 1 is the format to display the date in the form. 

=back

C<time_zone> and C<locale> are needed by Date::Time::Strptime.



To display new rows on a bound subform, connect the on_changed event to the field of the primary key in the main form.
In this sub, call a sub to synchonize the form:

In the main form:

    sub on_nofm_changed {
        my $widget = shift;
	my $self = shift;
	my $pk_value = $widget->get_text();
	$self->{subform_a}->synchronize_with($pk_value);
	...
	}

In the subform_a module
	
    sub synchronize_with {
	my ($self,$value) = @_;
	my $data = Rdb::Product::Manager->get_product(with_objects => ['seller_product'], query => ['seller_product.no_seller' => {eq => $value}]);
	$self->{subform_a}->get_data_manager->query($data);	
	$self->{subform_a}->update;
     }

=head2 Dealing with many to many relationship 

It's the sellers and products situation where a seller sells many products and a product is selled by many sellers.
One way is to have a insert statement that insert a new row in the linking table (named transaction for example) each time a new row is added in the product table.

An other way is to create a data manager for the transaction table

With DBI

	$dman = Gtk2::Ex::DbLinker::DbiDataManager->new({ dbh => $self->{dbh}, sql =>{select =>"no_seller, no_product", from => "transaction", where => ""}});

With Rose::DB::Object

	$data = Rdb::Transaction::Manager->get_transaction(query=> [no_seller => {eq => $current_seller }]);

	$dman = Gtk2::Ex::DbLinker::RdbDataManager->new({data => $data, meta=> Rdb::Transaction->meta});

And keep a reference of this for latter

      $self->{linking_data} = $dman;

If you want to link a new row in the table product with the current seller, create a method that is passed and array of primary key values for the current seller and the new product.

	sub update_linking_table {
	   	my ( $self, $keysref) = @_;
   		my @keys = keys %{$keysref};
		my $f =  $self->{main_form};
		my $dman = $self->{main_abo}->{linking_data};
		$dman->new_row;
		foreach my $k (@keys){
			my $value = ${$keysref}{$k};
			$dman->set_field($k, $value );
		}
		$dman->save;
	}

This method is to be called when a new row has been added to the product table:

	sub on_newproduct_applied_clicked {
		my $button = shift;
	 	my $self = shift;
    		my $main = $f->{main_form};
    		$self->{product}->apply;
		my %h;
		$h{no_seller}= $main->{no_seller};
		$h{no_product}= $self->{abo}->get_widget_value("no_product");
    		$self->update_linking_table(\%h);
	}

You may use the same method to delete a row from the linking table

	my $data = Rdb::Transaction::Manager->get_transaction(query=> [no_seller => {eq => $seller }, no_product=>{eq => $product } ] );
	$f->{linking_data}->query($data);
	$f->{linking_data}->delete;

=head1 DESCRIPTION

This module automates the process of tying data from a database to Wx widgets form described by a xrc file.
Name the widgets in the xrc file using the fields in your data source.

Steps for use:

=over

=item * 

Create a xxxDataManager object that contains the rows to display

=item * 

Create a builder object with a get_object($name) method

=item * 

Create a Wx::Perl::DbLinker::Wxform object that links the data and your form

=item *

You would then typically connect the buttons to the methods below to handle common actions
such as inserting, moving, deleting, etc.

=back

=head1 METHODS

=head2 constructor

The C<new();> method expects a hash reference of key / value pairs

=over

=item * 

C<data_manager> a instance of a xxxDataManager object

=item *

C<builder> 

C<$builder> is an object that must have a C<get_object($object_name)> which is a wrapper around C<Wx::Window::FindWindowByName> and C<frame()> method that return the application main window (holds in C<$self->{frame}> below:

   sub get_object {
	my ($self, $id) = @_;
	my $w = Wx::Window::FindWindowByName($id, $self->{frame});
	$self->{log}->debug("get_object: $id not found") unless (defined $w);
	return $w;
    }

=back

The following keys are optional

=over

=item *

C<datawidgets> a reference to an array of id in the glade file that will display the fields

=item * 

C<rec_spinner> the name of a GtkSpinButton to use as the record spinner or a reference to this widget. The default is to use a
widget called RecordSpinner.

=item *

C<rec_count_label>  name (default to "lblRecordCount") or a reference to a label that indicate the position of the current row in the rowset

=item *  

C<status_label> name (default to "lbl_RecordStatus") or a reference to a label that indicate the changed or syncronized flag of the current row

=item *

C<on_current> a reference to sub that will be called when moving to a new record

=item * 

C<date_formatters> a reference to an hash of Gtk2Entries id (keys), and format strings  that follow Rose::DateTime::Util (value) to display formatted Date

=item * 

C<auto_apply> defaults to 1, meaning that apply will be called if a changed has been made in a widget before moving to another record. Set this to 0 if you don't want this feature

=item *

C<datawidgets_changed> is a hash ref having the field's name as keys and a code ref that will be called when the field content is changed.

		$self->{sform} = Wx::Perl::DbLinker::Wxform->new({
		...
		datawidgets_changed => {langid=> sub{ on_langid_changed(@_, $self) } },
			});

		sub on_langid_changed {
			my ($widget, $event, $self) = @_;
			my $value = $widget->GetLineText(0);
			if ($value) {
				$self->{langid} = $value;
				$self->{sf_list}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} })  );
				$self->{sf_list}->update;
			}
		}

=item *

C<datawidgets_ro> is an array ref that gives the field's name that will be read-only.

=back

=head2 C<add_combo( {	data_manager =E<gt> $dman, 	id =E<gt> 'noed',  fields =E<gt> ["id", "nom"], }); >

Once the constructor has been called, combo designed in the xrc file received their rows with this method. 
Two Wx objects are supported Wx::ListCtrl and Wx::Combo.

C<return value> an array ref of the first field values is returned since in you have to retrieve the index of the selected row (holding nom values) to access the corresponding id

C<parameters> a hash reference, and the key and value are

=over

=item * 

C<data_manager> a dataManager instance that holds  the rows of the combo

=item *

C<id> the id of the widget in the xrc file

=item *

C<fields> an array reference holdings the names of fields in the combo (this parameter is needed with RdbDataManager only)

=back

=head2 C< Wx::Perl::DbLinker::Wxform-E<gt>add_combo({	data_manager =E<gt> $combodata, id =E<gt> 'countryid',	builder =E<gt> $builder,   }); >

This method can also be called as a class method, when the underlying form is not bound to any table. You need to pass the builder object (described above) as a supplemental parameter.

=head2 C<update();>

Reflect in the user interface the changes made after the data manager has been queried, or on the form creation

=head2 C<get_data_manager();>

Returns the data manager to be queried

=head2 C<set_data_manager( $dman ); >

Replaces the current data manager with the one receives. The columns should not changed, but this method can be use to change the join clause. 

=head2 C<get_widget_value ( $widget_id );>

Returns the value of a data widget from its id

=head2 C<set_widget_value ( $widget_id, $value )>;

Sets the value of a data widget from its id

=head2 Methods applied to a row of data

=over

=item *

C<insert()>;

Displays an empty rows at position 0 in the record_count_label.

=item *

C<delete();>

Marks the current row to be deleted. The delele itself will be done on apply.

=item *

C<apply():>

Save a new row, save changes on an existing row, or delete the row(s) marked for deletion.

=item *

C<undo();>

Revert the row to the original state in displaying the values fetch from the database.

=item *

C<next();>

=item *

C<previous()>;

=item *

C<first();>

=item *

C<last();>

=item *

C<add_childform( $childform );>

You may add any dependant form or datasheet object with this call if you want that a changed in this subform/datasheet be applied when the apply method of this form is called. 

=item *

C<has_changed();>

Return 1 if the data has been edited in the form and in any subform added with C<add_childform()> but not saved to the database. Return 0 otherwise.

=back

=head1 SUPPORT

Any Wx::Perl::DbLinker::Wxform questions or problems can be posted to me (rappazf) on my gmail account.  

The current state of the source can be extract using Mercurial from
L<http://sourceforge.net/projects/wx-perl-dblinker/>.

=head1 AUTHOR

FranE<ccedil>ois Rappaz <rappazf@gmail.com>

=head1 COPYRIGHT

Copyright (c) 2015 by F. Rappaz.  All rights reserved.
This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

=cut

1;


