package Data::Tubes::Plugin::Renderer;
use strict;
use warnings;
use English qw< -no_match_vars >;
our $VERSION = '0.727001';

use Log::Log4perl::Tiny qw< :easy :dead_if_first >;

use Data::Tubes::Util qw< normalize_args shorter_sub_names >;
use Data::Tubes::Util qw< read_file_maybe >;
my %global_defaults = (
   input  => 'structured',
   output => 'rendered',
);

sub _resolve_template {
   my $args = shift;
   my $template = read_file_maybe($args->{template});
   $template = $template->($args) if ref($template) eq 'CODE';
   LOGDIE 'undefined template' unless defined $template;
   $template = $args->{template_perlish}->compile($template)
     unless ref $template;
   return $template if ref($template) eq 'HASH';
   LOGDIE 'invalid template of type ' . ref($template);
} ## end sub _resolve_template

sub _create_tp {
   my $args = shift;
   require Template::Perlish;
   return Template::Perlish->new(
      map { $_ => $args->{$_} }
      grep { defined $args->{$_} } qw< start stop variables >
   );
} ## end sub _create_tp

sub render_with_template_perlish {
   my %args = normalize_args(
      @_,
      [
         {
            %global_defaults,
            start     => '[%',
            stop      => '%]',
            variables => {},
            name      => 'render with Template::Perlish',
         },
         'template'
      ]
   );
   my $name = $args{name};

   my $tp = $args{template_perlish} ||= _create_tp(\%args);
   my $template = _resolve_template(\%args);

   my $input  = $args{input};
   my $output = $args{output};
   return sub {
      my $record = shift;
      $record->{$output} = $tp->evaluate($template, $record->{$input});
      return $record;
   };
} ## end sub render_with_template_perlish

shorter_sub_names(__PACKAGE__, 'render_');

1;
