#!perl
# Copyright (C) 2001-2007, The Perl Foundation.
# $Id: say.t 30954 2008-09-10 09:10:56Z bernhard $

use strict;
use warnings;
use lib qw( . lib ../lib ../../lib );

use Test::More;
use Parrot::Test tests => 7;

=head1 NAME

t/op/say.t - Testing the say pseudo-opcode

=head1 SYNOPSIS

    % prove t/op/say.t

=head1 DESCRIPTION

Tests various PMCs and registers with say.

=cut

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a literal string' );
.sub main
    say "string literal"
.end
CODE
string literal
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a literal integer' );
.sub main
    say 42
.end
CODE
42
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a literal number' );
.sub main
    say 3.14
.end
CODE
3.140000
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a temporary string register' );
.sub main
    $S5 = "string register"
    say $S5
.end
CODE
string register
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a temporary integer register' );
.sub main
    $I4 = 10
    say $I4
.end
CODE
10
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say with a temporary number register' );
.sub main
    $N2 = 1.414
    say $N2
.end
CODE
1.414000
OUTPUT

pir_output_is( <<'CODE', <<'OUTPUT', 'say and print with a number register' );
.sub main
    $N0 = 3.14159
    say $N0
    print $N0
    print "\n"
.end
CODE
3.141590
3.141590
OUTPUT

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
