#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Object::Pad;

class Base::Class {
   has $data;
   method data { $data }

   method BUILDALL {
      $data = "base data"
   }
}

class Derived::Class extends Base::Class {
   has $data;
   method data { $data }

   method BUILDALL {
      $self->SUPER::BUILDALL;
      $data = "derived data";
   }
}

{
   my $c = Derived::Class->new;
   is( $c->data, "derived data",
      'subclass wins methods' );
   is( $c->Base::Class::data, "base data",
      'base class still accessible' );
}

done_testing;
