#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2016 -- leonerd@leonerd.org.uk

package App::MatrixTool::Command::directory;

use strict;
use warnings;
use base qw( App::MatrixTool );

use URI::Escape qw( uri_escape );

our $VERSION = '0.04';

use constant DESCRIPTION => "Look up room alias to room ID entries";
use constant ARGUMENTS => ( "alias" );
use constant OPTIONS => (
   's|servers' => 'Include list of candidate servers',
);

sub run
{
   my $self = shift;
   my ( $opts, $alias ) = @_;

   my ( $server ) = $alias =~ m/^\#[^:]*:(.*)$/ or
      return Future->fail( "Cannot parse room alias" );

   $self->http_client->request_json(
      method => "GET",
      server => $server,
      path   => "/_matrix/client/r0/directory/room/" . uri_escape( $alias ),
   )->then( sub {
      my ( $body ) = @_;

      my $room_id = $body->{room_id};

      $self->output( "room_id: " . $room_id );

      if( $opts->{servers} ) {
         my $servers = $body->{servers};

         $self->output( "candidate servers:" );
         $self->output( "  $_" ) for @$servers;
      }

      Future->done;
   });
}

0x55AA;
