package Perl::Critic::Bangs;

use warnings;
use strict;

=head1 NAME

Perl::Critic::Bangs - A collection of handy Perl::Critic policies

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

Perl::Critic::Bangs is a collection of Perl::Critic policies that
will help make your code better.
 
=head1 AUTHOR

Andy Lester, C<< <andy at petdance.com> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-perl-critic-bangs at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Perl-Critic-Bangs>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Perl::Critic::Bangs

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Perl-Critic-Bangs>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Perl-Critic-Bangs>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Perl-Critic-Bangs>

=item * Search CPAN

L<http://search.cpan.org/dist/Perl-Critic-Bangs>

=back

=head1 ACKNOWLEDGEMENTS

Thanks to
Aaron Moore for helping me get this off the ground.

=head1 COPYRIGHT & LICENSE

Copyright 2006 Andy Lester, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Perl::Critic::Bangs
