package WordList::PersonName::PopularBabyNames::US::SSA::2010::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"avg_word_len",5.803,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"num_words_contain_unicode",0,"shortest_word_len",2,"num_words",1000,"num_words_contains_unicode",0,"num_words_contain_whitespace",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 2010 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::2010::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 2010 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::2010::MaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::2010::MaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::2010::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.803 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Jacob
Ethan
Michael
Jayden
William
Alexander
Noah
Daniel
Aiden
Anthony
Joshua
Mason
Christopher
Andrew
David
Matthew
Logan
Elijah
James
Joseph
Gabriel
Benjamin
Ryan
Samuel
Jackson
John
Nathan
Jonathan
Christian
Liam
Dylan
Caleb
Landon
Tyler
Lucas
Evan
Nicholas
Gavin
Isaac
Brayden
Luke
Angel
Isaiah
Brandon
Jack
Jordan
Owen
Carter
Connor
Justin
Jeremiah
Jose
Julian
Robert
Aaron
Adrian
Wyatt
Kevin
Hunter
Cameron
Zachary
Thomas
Charles
Austin
Eli
Chase
Henry
Sebastian
Jason
Levi
Xavier
Ian
Colton
Dominic
Cooper
Juan
Josiah
Ayden
Luis
Adam
Nathaniel
Carson
Brody
Tristan
Parker
Diego
Blake
Oliver
Carlos
Cole
Jaden
Jesus
Alex
Aidan
Eric
Hayden
Bryan
Max
Jaxon
Bentley
Brian
Sean
Alejandro
Nolan
Riley
Kaden
Kyle
Micah
Vincent
Antonio
Colin
Bryce
Miguel
Timothy
Jake
Giovanni
Steven
Kaleb
Caden
Bryson
Damian
Grayson
Kayden
Jesse
Ashton
Brady
Richard
Victor
Patrick
Marcus
Preston
Joel
Maxwell
Santiago
Ryder
Edward
Miles
Asher
Hudson
Devin
Elias
Jeremy
Jonah
Ivan
Easton
Jace
Oscar
Collin
Peyton
Leonardo
Cayden
Gage
Emmanuel
Eduardo
Grant
Alan
Cody
Conner
Wesley
Kenneth
Mark
Malachi
Nicolas
Seth
George
Kaiden
Trevor
Jude
Jorge
Derek
Braxton
Sawyer
Jaxson
Jaiden
Omar
Tanner
Paul
Travis
Maddox
Camden
Andres
Cristian
Rylan
Josue
Bradley
Roman
Axel
Garrett
Fernando
Javier
Leo
Damien
Peter
Abraham
Ricardo
Francisco
Drake
Shane
Lincoln
Erick
Cesar
Stephen
Jaylen
Tucker
Kai
Landen
Braden
Mario
Edwin
Manuel
Avery
Trenton
Ezekiel
Kingston
Calvin
Johnathan
Edgar
Donovan
Silas
Israel
Jeffrey
Mateo
Alexis
Weston
Raymond
Hector
Spencer
Andre
Lukas
Brendan
Zion
Griffin
Harrison
Maximus
Andy
Braylon
Shawn
Tyson
Zane
Emiliano
Sergio
Ezra
Jared
Chance
Keegan
Charlie
Drew
Troy
Greyson
Simon
Clayton
Corbin
Myles
Xander
Dante
Erik
Rafael
Martin
Theodore
Dalton
Dominick
Skyler
Cash
Marco
Caiden
Ty
Johnny
Gregory
Kyler
Brennan
Emmett
Luca
Roberto
Declan
Kameron
Quinn
Jameson
Amir
Bennett
Colby
Emanuel
Malik
Pedro
Graham
Dean
Jasper
Everett
Aden
Dawson
Angelo
Reid
Dakota
Abel
Zander
Judah
Paxton
Ruben
Jakob
Jayce
Finn
Elliot
Frank
Lane
Dillon
Fabian
Brock
Derrick
Emilio
Ryker
Joaquin
Marcos
Devon
Anderson
Grady
Elliott
Corey
Holden
Amari
Dallas
Danny
Cruz
Allen
Trey
Lorenzo
Leland
Armando
Rowan
Taylor
Cade
Felix
Adan
Colt
Tristen
Jayson
Julius
Nehemiah
Julio
Zayden
Darius
Raul
Braydon
Louis
Ronald
Trent
Payton
Keith
Randy
Jax
Desmond
Enrique
Jett
Scott
Dustin
Gerardo
Phillip
Beckett
Ali
Romeo
Kellen
Cohen
Pablo
Ismael
Jaime
Larry
Kellan
Brycen
Keaton
Gunner
Braylen
Brayan
Landyn
Walter
Jimmy
Marshall
Beau
Donald
Phoenix
Esteban
Saul
Karson
Reed
Brenden
Jerry
Tony
Kade
Jamari
Mitchell
Brett
Colten
Arthur
Rocco
Dennis
Jalen
Tate
Chris
Quentin
Titus
Casey
King
Izaiah
Brooks
Mathew
Albert
Philip
Russell
Darren
Zackary
Gael
Braeden
Dane
Gustavo
Jay
Cullen
Kolton
Rodrigo
Alberto
Leon
Damon
Alec
Davis
Arturo
Waylon
Milo
Moises
Curtis
Walker
August
Kobe
Matteo
Emerson
Marvin
River
Mauricio
Maximilian
Orlando
Reece
Issac
Bryant
Yahir
Hugo
Uriel
Mohamed
Enzo
Karter
Lance
Porter
Zachariah
Maurice
Ricky
Leonel
Joe
Johan
Dexter
Jonas
Nikolas
Justice
Salvador
Lawrence
Knox
Gideon
Alfredo
Maximiliano
Talon
Solomon
Byron
Nickolas
Orion
Braiden
Kristopher
Alijah
Rhys
Sam
Jacoby
Jamarion
Gary
Davion
Noel
Pierce
Mekhi
Kason
Ramon
Cason
Shaun
Warren
Douglas
Reese
Cyrus
Armani
Ibrahim
Quinton
Ernesto
Jaydon
Isaias
Frederick
Chandler
Ryland
Deandre
Terry
Ari
Jamison
Dorian
Khalil
Moses
London
Franklin
Muhammad
Maverick
Ronan
Amare
Eddie
Nasir
Roger
Aldo
Demetrius
Adriel
Brodie
Prince
Kendrick
Morgan
Kelvin
Malcolm
Tobias
Ahmad
Trace
Keagan
Skylar
Alvin
Giovani
Conor
Abram
Camron
Jonathon
Bruce
Quincy
Noe
Rohan
Ahmed
Nathanael
Kamari
Kieran
Kristian
Barrett
Finnegan
Remington
Boston
Chad
Uriah
Micheal
Xzavier
Archer
Rodney
Bobby
Guillermo
Gunnar
Moshe
Kamden
Melvin
Julien
Roy
Atticus
Aaden
Ulises
Kane
Carl
Kasen
Lucian
Jeffery
Ezequiel
Javon
Terrance
Jadon
Nelson
Harley
Malakai
Triston
Jon
Aarav
Cory
Kian
Marc
Alonzo
Asa
Gianni
Wilson
Kole
Dayton
Jermaine
Terrence
Felipe
Kale
Kendall
Isiah
Nico
Dominik
Tommy
Finley
Cristopher
Tristin
Cannon
Jase
Wade
Ariel
Kash
Madden
Mohammed
Layne
Marlon
Rhett
Jamal
Memphis
Jessie
Joey
Nash
Allan
Reginald
Ace
Lawson
Giovanny
Zaiden
Aron
Korbin
Rashad
Will
Billy
Urijah
Leonard
Rene
Brennen
Branden
Kenny
Willie
Kody
Tomas
Brendon
Blaine
Alonso
Darian
Aydan
Raiden
Arjun
Sincere
Terrell
Marquis
Layton
Channing
Iker
Chace
Jordyn
Sullivan
Mohammad
Deshawn
Messiah
Brent
Omari
Raphael
Santino
Zechariah
Harry
Jaylin
Ray
Elisha
Jefferson
Luciano
Craig
Yandel
Bently
Tripp
Tristian
Aydin
Francis
Toby
Alexzander
Ronnie
Kylan
Semaj
Lee
Alessandro
Dwayne
Gerald
Jadiel
Javion
Markus
Stanley
Davin
Kolby
Neil
Teagan
Harper
Jamie
Makai
Cale
Ben
Deacon
Clark
Jairo
Callen
Damarion
Kaeden
Kareem
Aidyn
Damion
Davian
Rex
Jamir
Lamar
Jorden
Case
Duncan
Jaeden
Matias
Vicente
Jasiah
Tyrone
Aryan
Lewis
Zayne
Yusuf
Gavyn
Giancarlo
Rogelio
Rolando
Camren
Jensen
Cedric
Osvaldo
Soren
Luka
Mathias
Ellis
Maxim
Rylee
Draven
Nikolai
Darwin
Bradyn
Brantley
Emery
Zavier
Zackery
Rudy
Trevon
Jerome
Royce
Daxton
Alfonso
Harold
Rory
Beckham
Darrell
Jaylon
Rodolfo
Keenan
Tatum
Sterling
Van
Bruno
Gauge
Hamza
Ayaan
Rayan
Zachery
Heath
Dax
Jagger
Jovani
Killian
Conrad
Junior
Augustus
Misael
Roland
Vance
Alvaro
Bode
Eugene
Ramiro
Yosef
Adrien
Carmelo
Wayne
Kamron
Johnathon
Kolten
Gilberto
Quintin
Steve
Zain
Antoine
Niko
Tyrell
Hassan
Jeramiah
Bronson
Coleman
Elian
Valentin
Clay
Frankie
Jaxton
Jean
Jamar
Kymani
Adonis
Kayson
Freddy
Hank
Efrain
Lyric
Samir
Abdiel
Ean
Sage
Todd
Leandro
Aditya
Deven
Konner
Konnor
Matthias
Derick
Kyron
Benson
Deangelo
Demarcus
Jovanni
Kyson
Sidney
Valentino
Gilbert
Ishaan
Maximo
Dilan
Xavi
Bo
Sylas
Fisher
Jaron
Marcel
Franco
Cael
Alden
Blaze
Malaki
Randall
Bentlee
Brogan
Callum
Jerimiah
Justus
Westin
Agustin
Rey
Ronin
Branson
Marcelo
Dominique
Krish
Odin
Chaim
Brice
Camryn
Izayah
Jabari
Jaidyn
Jair
Remy
Samson
Tyree
Mayson
Emmitt
Isai
Mike
Santos
Seamus
Stefan
Jedidiah
Deon
Devan
Houston
Winston
Casen
Fletcher
Major
Vincenzo
Aedan
Darnell
Kamryn
Gaige
Jaycob
Quinten
Jaxen
Landry
Deegan
Edison
Howard
Humberto
Jadyn
Salvatore
Lionel
Aarush
Kadyn
Carsen
Jaydin
Abdullah
Alfred
Ameer
Bodhi
Davon
Trystan
Eden
Johann
Zaire
Antwan
Donte
Jayvion
Lennon
Marley
Theo
Bridger
Irvin
Yael
Devyn
Ernest
Hezekiah
Leonidas
Leroy
Ross
Ignacio
Jencarlos
Leighton
Octavio
Rayden
Arnav
Lennox
Nigel
Darien
Hayes
Keon
Vaughn
Anders
Legend
Cortez
Darryl
Haiden
Koen
Dario
Jakobe
Sonny
Pierre
Tyrese
Zaid
Blaise
Damari
Maxx
Menachem
Antony
Dangelo
Cain
Camdyn
Eliot
Hugh
Makhi
Pranav
Roderick
Yadiel
Broderick
Ralph
Zack
Demarion
Kael
Lathan
Ronaldo
Yair
Gibson
Keyon
Reagan
Daylen
Kingsley
Talan
Yehuda
Cristofer
Dashawn
Dillan
Jordon
Sheldon
Slade
Clarence
Kadin
Masen
Rowen
Clinton
Thaddeus
Yousef
Truman
Bailey
Destin
Eliezer
Enoch
Joziah
Keshawn
