package WordList::PersonName::PopularBabyNames::US::SSA::1940::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("shortest_word_len",2,"num_words_contains_unicode",0,"num_words",1000,"num_words_contain_whitespace",0,"avg_word_len",5.981,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"num_words_contain_unicode",0,"longest_word_len",10,"num_words_contain_nonword_chars",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1940 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1940::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1940 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1940::FemaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1940::FemaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1940::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.981 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Barbara
Patricia
Judith
Betty
Carol
Nancy
Linda
Shirley
Sandra
Margaret
Dorothy
Joyce
Joan
Carolyn
Judy
Sharon
Helen
Janet
Elizabeth
Virginia
Janice
Donna
Ruth
Marilyn
Martha
Beverly
Frances
Jean
Gloria
Doris
Alice
Phyllis
Karen
Ann
Susan
Peggy
Lois
Bonnie
Kathleen
Marie
Brenda
Norma
Rose
Diane
Geraldine
Jane
Evelyn
Carole
Elaine
Anna
Wanda
Catherine
Joanne
Charlotte
Annie
Patsy
Mildred
Louise
Sarah
Sally
Sylvia
Joann
Marjorie
Gail
Ruby
Dolores
Eleanor
Loretta
Rita
Roberta
Jo
Irene
Ellen
Arlene
Jacqueline
Kay
Juanita
Darlene
Marlene
Sue
June
Delores
Anne
Rosemary
Edna
Anita
Connie
Josephine
Jeanette
Katherine
Julia
Wilma
Emma
Lorraine
Rebecca
Lillian
Edith
Audrey
Florence
Thelma
Theresa
Kathryn
Pauline
Grace
Ethel
Glenda
Laura
Suzanne
Yvonne
Clara
Marcia
Lucille
Margie
Vivian
Gladys
Diana
Christine
Maria
Marion
Bernice
Sara
Hazel
Constance
Eileen
Annette
Priscilla
Willie
Jeanne
Sheila
Esther
Eva
Cynthia
Pat
Maureen
Deanna
Maxine
Georgia
Rosalie
Bertha
Beatrice
Marian
Lillie
Ida
Charlene
Ella
Bobbie
Rosa
Billie
Myrna
Elsie
Alma
Faye
Lucy
Paula
Maryann
Harriet
Jessie
Vera
Joy
Nellie
Bessie
Mattie
Emily
Lynda
Rachel
Dianne
Minnie
Gwendolyn
Agnes
Dixie
Caroline
Rosemarie
Rosie
Patty
Carrie
Gayle
Geneva
Naomi
Julie
Dora
Jeannette
Leona
Myrtle
Mae
Gertrude
Shelby
Velma
Jackie
Viola
Cora
Stella
Lynn
Claire
Alberta
Nina
Pearl
Hattie
Sondra
Madeline
Deloris
Eunice
Lola
Verna
Claudia
Johnnie
Sherry
Marianne
Nora
Ramona
Carmen
Lula
Janie
Valerie
Hilda
Lena
Violet
Daisy
Ernestine
Marguerite
Fannie
Iris
Bettie
Irma
Myra
Lynne
Antoinette
Erma
Marsha
Susie
Miriam
Melba
Bette
Angela
Lydia
Regina
Marcella
Sonja
Andrea
Bettye
Jacquelyn
Flora
Victoria
Teresa
Mamie
Ada
Jennie
Della
Colleen
Katie
Pamela
Cecilia
Beulah
Genevieve
Betsy
Kathy
Mable
Muriel
Laverne
Janis
Cecelia
Inez
Veronica
Mabel
Reba
Eula
Henrietta
Nelda
Olivia
Lila
Sadie
Jerry
Opal
Claudette
Bonita
Frankie
Maggie
Eloise
Amelia
Fay
Lou
Penny
Lee
Freda
Saundra
Nadine
Sallie
Jimmie
Gretchen
Beth
Deborah
Mona
Rosetta
Glenna
Rochelle
Blanche
Sharron
Lorene
Carla
Penelope
Earnestine
Helene
Dawn
Etta
Nettie
Lana
Ina
Ollie
Essie
Gracie
Ora
Lorna
Polly
Joanna
Lenora
Vicki
Ruthie
Dorthy
Natalie
Stephanie
Amy
Jill
Gale
Estelle
Winifred
Sandy
Celia
Iva
Willa
Faith
Terry
Rosalind
Sybil
Leah
Earlene
Imogene
Estella
Gwen
Darla
Earline
Kaye
Yolanda
Beverley
Dorothea
Addie
Ola
Pearlie
Becky
Molly
Christina
Josie
Lela
Lupe
Mavis
Olga
Jan
Marilynn
Lavonne
Fern
Isabel
Lottie
Denise
Bernadine
Bernadette
Adele
Jewel
Leola
Susanne
Janette
Francis
Rhoda
Cecile
Alicia
Clarice
Jewell
Renee
Robbie
Gay
Rena
Harriett
Margo
Dale
Melinda
Cleo
Elva
Marylou
Sonia
Adrienne
Francine
Toni
Camille
Marva
Nell
Marlys
Carlene
Jeannine
Guadalupe
Alta
Effie
Lizzie
Melva
Eddie
Dianna
Judie
Laurel
Virgie
Monica
Elinor
May
Cheryl
Doreen
Lora
Jeannie
Tommie
Elnora
Dolly
Johanna
Arleen
Arline
Dona
Edwina
Goldie
Margarita
James
Nola
Delia
Leslie
Wendy
Cornelia
Luella
Eugenia
Noreen
Winnie
Dana
Jeanie
Jannie
Nona
Patti
Mollie
Elvira
Jenny
Lenore
Merle
Angie
Rosalyn
Corinne
Marietta
Millie
Freddie
Angelina
Ilene
Paulette
Amanda
Joe
Therese
Corrine
Angeline
Dollie
Hope
Ila
Margery
Roseann
John
Jayne
Alyce
Maryanne
Robert
Robin
Wilda
Elma
Lucinda
Nannie
Neva
Adeline
Ginger
Judi
Peggie
Frieda
Helena
Louella
Melanie
Rosalee
Rosella
Antonia
Dottie
Sonya
Queen
Rae
Sherrill
Carmela
Letha
Retha
Reva
Ruthann
Bennie
Cathy
Madeleine
Avis
Jeanine
Carmella
Zelma
Nan
Annabelle
Hannah
Isabelle
Delois
Gerry
Jolene
Lily
Madelyn
Odessa
Roxie
Deanne
Leila
Corine
Tamara
Maryellen
Callie
Dee
Nita
Shelba
Clare
Evangeline
Meredith
Tina
Ladonna
Olive
Sophie
Eleanore
Lilly
Ardith
Lucile
Annetta
Pansy
Trudy
Claudine
Lorena
Maryjane
Emilie
Georgianna
Loraine
Vickie
Georgie
Katharine
Roslyn
Florine
Lucia
Nedra
Elouise
Carroll
Flossie
Gearldine
Reta
Matilda
Sheryl
Aurora
Carrol
Caryl
Concetta
Doretha
Ima
Ester
Lelia
William
Kitty
Phoebe
Selma
Bobby
Greta
Ophelia
Sharlene
Consuelo
Eliza
Vivien
Allie
Esperanza
Marla
Toby
Lucretia
Maude
Twila
Vernell
Lona
Lynette
Freida
Lessie
Suellen
Celeste
Charles
Marlyn
Justine
Karla
Karol
Madonna
Vonda
Aileen
Aline
Darleen
Elena
Laurie
Mercedes
Charlie
Diann
Leta
Louisa
Sammie
Lauretta
Leota
Hester
Julianne
Harriette
Treva
Beryl
George
Gussie
Karin
Winona
Belva
Lorine
Rosanne
Zelda
Ardis
Carolann
Madge
Marilee
Delma
Georgette
Theodora
Carolee
Dian
Margot
Celestine
Jeraldine
Merry
Bertie
Camilla
Jerrie
Pearline
Roma
Elsa
Charleen
Maudie
Rowena
Yvette
Cathleen
Delphine
Elise
Georgiana
Alfreda
Birdie
Donnie
Alene
Elisabeth
Verla
Vicky
Zella
Lue
Pattie
Cherry
Adelaide
Barbra
Marjory
Shirlene
Syble
Jaunita
Petra
Richard
Vada
Carolynn
Edythe
Karolyn
Clementine
Heather
Roselyn
April
Dorene
Karon
Minerva
Ronda
Sophia
Wilhelmina
Susanna
Carleen
Lonnie
Velda
Crystal
Gertie
Janelle
Jennifer
Malinda
Margret
Michele
Althea
Felicia
Lavon
Millicent
Dessie
Marianna
Mickey
Ofelia
Oma
Alva
Daphne
Juliana
Annmarie
Charmaine
Georgene
Hellen
Iona
Sherrie
Emogene
Josefina
Marylin
Berta
Dorris
Melissa
Valeria
Kate
Leora
Shirlee
Garnet
Iola
Merlene
Patrica
Una
Carmelita
Gaynell
Michelle
Cherie
Ione
Maurine
Letitia
Roxanne
Allene
Gaye
Juliette
Lisa
Myrtis
Norene
Theda
Angelita
Cordelia
Dorcas
Evangelina
Katheryn
Lonna
Manuela
Oralia
Rhea
Thomas
Ursula
Debra
Dortha
Dovie
Enid
Leilani
Linnie
Marge
Nila
Raquel
Sydney
David
Donald
Elida
Germaine
Lura
Mariann
Melvina
Nanette
Socorro
Vesta
Adela
Elisa
Francisca
Janell
Lavada
Lavern
Lolita
Mina
Erna
Jacklyn
Jonnie
Kathie
Shelia
Agatha
Bonny
Cathryn
Katy
Marina
Tillie
Juliet
Margarett
Michael
Veda
Aurelia
Benita
Easter
Leanna
Leanne
Marylyn
Albertha
Carolina
Charline
Jeri
Juana
Libby
Marta
Augusta
Ava
Berniece
Cleta
Isabell
Isabella
Lea
Magdalene
Magnolia
Vernice
Idella
Willia
Chloe
Colette
Ernestina
Florene
Ilona
Lettie
Verda
Cecil
Cindy
Hallie
Holly
Jamie
Lyla
Ronnie
Sidney
Dena
Larry
Noel
Oleta
Rhonda
Rosario
Alpha
Eve
Laraine
Louann
Marleen
Shannon
Susann
Zona
Catharine
Gilda
Hedy
Jacquelin
Louvenia
Eartha
Loyce
Roseanne
Shelva
Tanya
Alvina
Jeanetta
Phylis
Adell
Georgina
Ira
Leonora
Margarette
Ona
Bridget
Joycelyn
Lovie
Magdalena
Novella
Ouida
Rachael
Rona
Sharen
Shari
Ana
Christene
Elda
Emilia
Ivy
Leatha
Luann
Martina
Nancie
Bernardine
Darline
Kathrine
Marita
Philomena
Prudence
Venita
Alexandra
Earlean
Ingrid
Joseph
Karlene
Maryjo
Marylee
Mazie
Norine
Rosanna
Simone
Velva
Carma
Deana
Deann
Esta
Marvel
Shelley
Bobbye
Herminia
Lina
Luanne
Rosita
Debbie
Erlinda
Jessica
Kattie
Leatrice
Marilou
Nella
Rozella
Vergie
Willene
Zola
Billy
Cassie
Fran
Glynda
Lawanda
Mittie
Nannette
Belinda
Clarissa
Floy
Gene
Johnny
Lyn
Lynnette
Rutha
Scarlett
Christie
Drucilla
Gayla
Jerri
Joellen
Lavina
Lorelei
Ronald
Abbie
Ardella
Larue
Twyla
Vida
Dominga
Eldora
Elease
Elna
Jocelyn
Adelina
Coleen
Henry
Myrtice
Pam
Romona
Ruthanne
Serena
Artie
Bernita
Evie
Evonne
Joetta
Kenneth
Maxie
Rosia
Wynona
Zoe
Beverlee
Carlotta
Cruz
Evon
Jody
Juliann
Paul
Sherron
Vonnie
Beatriz
Bethel
Carolyne
Donita
Evalyn
Merilyn
Rubye
Annis
Arla
Billye
Georgiann
Hettie
