package WordList::PersonName::PopularBabyNames::US::SSA::1930::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"num_words_contain_unicode",0,"avg_word_len",5.771,"shortest_word_len",2,"num_words_contain_whitespace",0,"num_words_contains_unicode",0,"num_words",1000); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1930 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1930::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1930 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1930::MaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1930::MaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1930::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.771 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Robert
James
John
William
Richard
Charles
Donald
George
Joseph
Edward
Thomas
Paul
Frank
Jack
David
Raymond
Kenneth
Harold
Walter
Billy
Eugene
Henry
Arthur
Albert
Ralph
Carl
Joe
Harry
Willie
Gerald
Howard
Fred
Roy
Louis
Herbert
Lawrence
Ronald
Earl
Clarence
Norman
Bobby
Francis
Ernest
Anthony
Leonard
Alfred
Daniel
Marvin
Stanley
Melvin
Jerry
Bernard
Leroy
Michael
Samuel
Peter
Ray
Roger
Bill
Russell
Floyd
Andrew
Leo
Dale
Wayne
Edwin
Theodore
Don
Lloyd
Gene
Glenn
Vernon
Clifford
Frederick
Philip
Clyde
Gordon
Herman
Alvin
Elmer
Leon
Lee
Martin
Vincent
Allen
Jimmie
Lewis
Bob
Douglas
Gilbert
Charlie
Harvey
Milton
Jesse
Lester
Warren
Eddie
Arnold
Cecil
Victor
Johnny
Jimmy
Chester
Johnnie
Jerome
Curtis
Larry
Roland
Bruce
Sam
Calvin
Wallace
Jose
Benjamin
Glen
Maurice
Willard
Patrick
Edgar
Manuel
Duane
Claude
Billie
Oscar
Jim
Marion
Tommy
Virgil
Dean
Keith
Hugh
Tom
Jessie
Everett
Junior
Alan
Hubert
Stephen
Leslie
Rudolph
Wilbur
Wesley
Max
Phillip
Dennis
Homer
Nicholas
Luther
Franklin
Sidney
Delbert
Morris
Earnest
Ben
Allan
Ted
Jackie
Horace
Willis
Lyle
Dick
Bennie
Tony
Juan
Dan
Jay
Salvatore
Alexander
Steve
Oliver
Freddie
Otis
Darrell
Guy
Neil
Julius
Edmund
Clayton
Archie
Alex
Carroll
Alton
Ramon
Clifton
Nathaniel
Jesus
Orville
Marshall
Antonio
Angelo
Lowell
Wilbert
Gary
Lonnie
Merle
Myron
Mike
Leland
Ira
Bobbie
Clinton
Wendell
Ivan
Matthew
Dewey
Karl
Irving
Rodney
Nelson
Nick
Ervin
Jacob
Elbert
Wilfred
Doyle
Gerard
Sylvester
Irvin
Mark
Julian
Perry
Carlos
Pete
Eldon
Rufus
Laurence
Norbert
Burton
Malcolm
Isaac
Fredrick
Bert
Dwight
Rex
Nathan
Loren
Benny
Roosevelt
Tommie
Troy
Forrest
Ellis
Felix
Ruben
Owen
Emil
Grady
Conrad
Mack
Aaron
Pedro
Loyd
Ross
Irwin
Francisco
Byron
Sherman
Carlton
Johnie
Elwood
Amos
Lynn
Joel
Harley
Mario
Seymour
Emmett
Otto
Buddy
Rudy
August
Boyd
Percy
Wilson
Harlan
Reginald
Dominick
Teddy
Murray
Stuart
Raul
Sheldon
Grover
Laverne
Roberto
Louie
Aubrey
Garland
Danny
Austin
Dallas
Neal
Preston
Dominic
Alfonso
Pat
Luis
Erwin
Cornelius
Morton
Edmond
Maynard
Roscoe
Sammie
Sammy
Abraham
Elvin
Mary
Dave
Millard
Merlin
Delmar
Clair
Steven
Marlin
Timothy
Grant
Elton
Wade
Adolph
Terry
Salvador
Charley
Moses
Royce
Jean
Cleveland
Jasper
Reuben
Simon
Darwin
Lionel
Kermit
Marcus
Carmen
Sanford
Adam
Shirley
Randolph
Alfredo
Alonzo
Hollis
Armando
Christopher
Odell
Darrel
Wilmer
Gus
Lavern
Monroe
Thurman
Merrill
Ned
Ollie
Stewart
Will
Andy
Frankie
Clark
Emanuel
Travis
Wilburn
Gregory
Mitchell
Guadalupe
Weldon
Armand
Barry
Harrison
Buford
Randall
Rocco
Ed
Clement
Rolland
Lamar
Norris
Elijah
Russel
Ward
Jake
Miguel
Van
Vern
Carol
Gabriel
Basil
Patsy
Barney
Jackson
Ricardo
Coy
Noel
Rafael
Cyril
Earle
Woodrow
Lorenzo
Wiley
Wilford
Pablo
Alva
Cleo
Jess
Sterling
Dudley
Normand
Eric
Forest
Adrian
Rodolfo
Vito
Emory
Truman
Booker
Hershel
Winston
Carmine
Gale
Hector
Levi
Mervin
Claud
Emery
Solomon
Carrol
Eli
Jerald
Noah
Silas
Phil
Winfred
Elmo
Arturo
Harris
Rene
Linwood
Nolan
Enrique
Bud
Cletus
Delmer
Elliott
Jeff
Donnie
Emilio
Huey
Orval
Thaddeus
Al
Chris
Elias
Fernando
Milford
Emerson
Herschel
Ernesto
Lenard
Angel
Kent
Miles
Roman
Freeman
Pasquale
Frederic
Hoyt
Riley
Bruno
Alphonse
Bertram
Julio
Royal
Alberto
Blaine
Tomas
Vance
Betty
Milo
Olin
Dorothy
Hal
Roderick
Spencer
Gail
Lyman
Odis
Saul
Vaughn
Ulysses
Alden
Monte
Scott
Wilber
Anton
Ferdinand
Hiram
Wilton
Hugo
Dalton
Major
Buster
Ignacio
Luke
Ronnie
Domingo
Felipe
Gilberto
Arlen
Merlyn
Arden
Denver
Dwayne
Elroy
Omer
Burl
Daryl
Everette
Olen
Hobert
Carlo
Connie
Gaylord
Arlie
Clay
Rodger
Alphonso
Marcel
Raymon
Dewitt
Frances
Jeremiah
Houston
Evan
Doris
Ellsworth
Mickey
Andres
Bryan
Dana
Micheal
Abel
Anderson
Augustine
Bradley
Harmon
Augustus
Emile
Foster
Mathew
Fletcher
Freddy
Isaiah
Verne
Jules
Rollin
Santiago
Kelly
Arther
Columbus
Orlando
Ramiro
Waldo
Justin
Merton
Nickolas
Noble
Rogers
Sebastian
Jewel
Shelby
Valentine
Davis
Ezra
Lupe
Theron
Coleman
Morgan
Quentin
Hilton
Mckinley
Alford
Carson
Lucien
Craig
Edd
Jason
Kay
Reed
Warner
Ambrose
Clarance
Edsel
Elden
Ernie
Galen
Harland
Isiah
Joesph
Talmadge
Avery
Beverly
Donn
Jonathan
Mose
Alejandro
Benito
Graham
Lacy
Lemuel
Stanford
Eduardo
Guillermo
Hans
Israel
Palmer
Romeo
Jefferson
Bernie
Jerrold
Newton
Donal
Hermon
Kennith
Maxwell
Raphael
Santos
Sol
Winford
Aurelio
Granville
Mason
Christian
Cyrus
Enoch
Casimir
Domenic
Donovan
Werner
Aloysius
Hoover
Rubin
Vicente
Brian
King
Sonny
Walker
Adolfo
Joshua
Judson
Otha
Raleigh
Rayford
Theo
Alvis
Benedict
Dexter
Dorsey
Gayle
Haywood
Kyle
Sherwood
Bradford
Dee
Denis
Elwin
Felton
Boyce
Claudie
Haskell
Lois
Ora
Oren
Abe
Jon
Lincoln
Loy
Lucius
Santo
Dock
Theadore
Gregorio
Kevin
Rosario
Bennett
Bryce
Fay
Helen
Lucian
Alvie
Eldridge
Sydney
Eldred
Gino
Junius
Marlyn
Elvis
Fidel
Napoleon
Ottis
June
Leeroy
Rupert
Walton
Asa
Burt
Constantine
Jordan
Porter
Taylor
Aldo
Benton
Blair
Dolores
Elwyn
Jonas
Kurt
Reynold
Denny
Dewayne
Dillard
Dwain
Elzie
Emmitt
Farrell
Hobart
Jerold
Joyce
Ken
Nicolas
Bernice
Franklyn
Ismael
Merritt
Sandy
Waymon
Zane
Andre
Barbara
Elliot
Guido
Jewell
Lawerence
Williams
Willian
Crawford
Joaquin
Lindsey
Lon
Bonnie
Fredric
Garfield
Milan
Orin
Regis
Elisha
Elmore
Glendon
Gustave
Hayward
Ignatius
Mahlon
Matt
Myles
Robin
Alois
Clem
Delton
Margaret
Oswald
Ruth
Agustin
Domenick
Ivory
Oran
Reynaldo
Virginia
Arvil
Joan
Verlin
Albin
Antone
Ardell
Aron
Brady
Buck
Duncan
Glynn
Kendall
Kirby
Mac
Meredith
Pearl
Rudolf
Shelton
Terrence
Vernie
Winfield
Clovis
Eddy
Loran
Melton
Arvid
Carey
Carleton
Carmelo
Florian
Omar
Rowland
Val
Barton
Cruz
Evans
Lindy
Virgle
Chauncey
Furman
Garry
Gerry
Giles
Maxie
Miller
Murry
Prince
Carter
Dwaine
Estel
Loyal
Newell
Norton
Norval
Ruby
Arlo
Audrey
Berry
Bertrand
Darold
Murphy
Rose
Tim
Tracy
Art
Arvin
Auther
Bryant
Carlyle
Davie
Fritz
Gearld
Ike
Isadore
Leander
Lucious
Margarito
Rosendo
Willam
Clare
Clint
Dorman
Edison
Garnett
Hardy
Malvin
Marcelino
Pierre
Casper
Dannie
Derald
Derl
Emmet
Norwood
Obie
Reid
Addison
Arlin
Dayton
Early
Ezell
Jennings
Jere
Kenny
Lambert
Leopoldo
Mariano
Vester
Adolphus
Eloy
Lauren
Lorin
Orrin
Stanton
Wylie
Arnulfo
Cedric
Cleon
Cloyd
Damon
Dempsey
Ezekiel
Gerold
Gonzalo
Harlen
Humberto
Lavon
Lynwood
Maria
Pierce
Seth
Beryl
Burnell
Davey
Farris
Garth
Oneal
Silvio
Arlan
Brooks
Cary
Dante
Deane
Hazel
Hillard
Hyman
Jorge
Lane
Lenord
Refugio
Rollie
Winton
Anna
Earlie
Federico
Garrett
Johnson
Joy
Judge
Lawson
Lenwood
Louise
Marco
Patricia
Thad
Turner
Urban
Alice
Author
Christ
Curtiss
Dino
Duwayne
Gustav
Howell
Ivy
Nunzio
Richmond
Rosevelt
Sherwin
Verlyn
Adan
Annie
Clive
Evelyn
Evert
Hayden
Madison
Otho
Parker
Wally
Johny
Leamon
Llewellyn
Lonzo
Marcellus
Melville
Orland
Webster
Abner
Allison
Artie
Artis
Durwood
Elizabeth
Emmit
Finis
Florentino
Hamilton
Hosea
Ransom
Rueben
Thornton
Benjiman
Cameron
Claire
Cleve
Conley
Ford
Genaro
Hurley
Jodie
Marshal
Mervyn
