package Sort::Sub::first_num_in_text;

our $DATE = '2016-12-18'; # DATE
our $VERSION = '0.09'; # VERSION

use 5.010001;
use strict;
use warnings;
require Sort::Sub::num_in_text;
*gen_sorter = \&Sort::Sub::num_in_text::gen_sorter;

1;
# ABSTRACT: Alias for Sort::Sub::num_in_text

__END__

=pod

=encoding UTF-8

=head1 NAME

Sort::Sub::first_num_in_text - Alias for Sort::Sub::num_in_text

=head1 VERSION

This document describes version 0.09 of Sort::Sub::first_num_in_text (from Perl distribution Sort-Sub), released on 2016-12-18.

=for Pod::Coverage ^(gen_sorter)$

=head1 SYNOPSIS

Generate sorter (accessed as variable) via L<Sort::Sub> import:

 use Sort::Sub '$first_num_in_text'; # use '$first_num_in_text<i>' for case-insensitive sorting, '$first_num_in_text<r>' for reverse sorting
 my @sorted = sort $first_num_in_text ('item', ...);

Generate sorter (accessed as subroutine):

 use Sort::Sub 'first_num_in_text<ir>';
 my @sorted = sort {first_num_in_text} ('item', ...);

Generate directly without Sort::Sub:

 use Sort::Sub::first_num_in_text;
 my $sorter = Sort::Sub::first_num_in_text::gen_sorter(
     ci => 1,      # default 0, set 1 to sort case-insensitively
     reverse => 1, # default 0, set 1 to sort in reverse order
 );
 my @sorted = sort $sorter ('item', ...);

Use in shell/CLI with L<sortsub> (from L<App::sortsub>):

 % some-cmd | sortsub first_num_in_text
 % some-cmd | sortsub first_num_in_text --ignore-case -r

=head1 DESCRIPTION

This module can generate sort subroutine. It is meant to be used via L<Sort::Sub>, although you can also use it directly via C<gen_sorter()>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sort-Sub>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sort-Sub>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sort-Sub>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Sort::Sub>

L<Sort::Sub::num_in_text>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
