## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::re_or_code_from_str;

our $DATE = '2023-09-09'; # DATE
our $VERSION = '0.004'; # VERSION

our $rschema = do{my$var={base=>"any",clsets_after_base=>[{description=>"\nEither Regexp object or coderef is accepted.\n\nCoercion from string is available for Regexp If string is of the form of `/.../`\nor `qr(...)`, then it will be compiled into a Regexp object. If the regex\npattern inside `/.../` or `qr(...)` is invalid, value will be rejected.\nCurrently, unlike in normal Perl, for the `qr(...)` form, only parentheses `(`\nand `)` are allowed as the delimiter. Currently modifiers `i`, `m`, and `s`\nafter the second `/` are allowed.\n\nCoercion from string is available for coderef if string matches the regex\n`qr/\\Asub\\s*\\{.*\\}\\z/s`, then it will be eval'ed into a coderef. If the code\nfails to compile, the value will be rejected. Note that this means you accept\narbitrary code from the user to execute! Please make sure first and foremost\nthat this is acceptable in your case. Currently string is eval'ed in the `main`\npackage, without `use strict` or `use warnings`.\n\nCoercion from string to regex literal is also available for other forms of\nstring.\n\nThis schema is handy if you want to accept regex or coderef from the\ncommand-line.\n\n",examples=>[{summary=>"Converted to regex",valid=>1,value=>""},{summary=>"Converted to regex",valid=>1,value=>"a"},{summary=>"Not a regex or code",valid=>0,value=>{}},{valid=>1,value=>qr()},{valid=>1,value=>sub{package Sah::Schema::re_or_code_from_str;use strict}},{valid=>1,validated_value=>qr(),value=>"//"},{valid=>1,validated_value=>qr(foo.*),value=>"/foo.*/"},{valid=>1,validated_value=>qr(foo.*),value=>"qr(foo.*)"},{valid=>1,validated_value=>qr(foo)si,value=>"/foo/is"},{valid=>1,validated_value=>qr(foo)si,value=>"qr(foo)is"},{summary=>"Invalid regex",valid=>0,value=>"/foo[/"},{code_validate=>sub{package Sah::Schema::re_or_code_from_str;use strict;ref $_[0] eq 'CODE' & !defined($_[0]->())},valid=>1,value=>"sub {}"},{code_validate=>sub{package Sah::Schema::re_or_code_from_str;use strict;$_[0]->() eq 'foo' if ref $_[0] eq 'CODE'},valid=>1,value=>"sub{\"foo\"}"},{summary=>"Code does not compile",valid=>0,value=>"sub {1=2}"}],of=>[["re"],["code"]],prefilters=>["Str::maybe_convert_to_re","Str::maybe_eval"],summary=>"Regex (convertable from string of the form `/.../`) or coderef (convertable from string of the form `sub { ... }`)"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["any"],type=>"any",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Regex (convertable from string of the form `/.../`) or coderef (convertable from string of the form `sub { ... }`)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::re_or_code_from_str - Regex (convertable from string of the form `/.../`) or coderef (convertable from string of the form `sub { ... }`)

=head1 VERSION

This document describes version 0.004 of Sah::SchemaR::re_or_code_from_str (from Perl distribution Sah-Schemas-Re), released on 2023-09-09.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Re>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Re>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Re>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
