package Sah::Schema::perl_modname_or_filename;

our $DATE = '2017-01-31'; # DATE
our $VERSION = '0.007'; # VERSION

our $schema = [str => {
    summary => 'Perl module name or file name',
    'x.perl.coerce_rules' => [
        'str_normalize_perl_modname_or_filename',
    ],

    'x.completion' => sub {
        require Complete::File;
        require Complete::Module;
        require Complete::Util;

        my %args = @_;
        my $word = $args{word};

        my @answers;
        push @answers, Complete::File::complete_file(word => $word);
        if ($word =~ m!\A\w*((?:::|/)\w+)*\z!) {
            push @answers, Complete::Module::complete_module(word => $word);
        }

        Complete::Util::combine_answers(@answers);
    },

}, {}];

1;
# ABSTRACT: Perl module name or file name

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::perl_modname_or_filename - Perl module name or file name

=head1 VERSION

This document describes version 0.007 of Sah::Schema::perl_modname_or_filename (from Perl distribution Sah-Schemas-Perl), released on 2017-01-31.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Perl>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Perl>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Perl>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
