package Sah::Schemas::Path;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-08-14'; # DATE
our $DIST = 'Sah-Schemas-Path'; # DIST
our $VERSION = '0.018'; # VERSION

1;
# ABSTRACT: Schemas related to filesystem path

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schemas::Path - Schemas related to filesystem path

=head1 VERSION

This document describes version 0.018 of Sah::Schemas::Path (from Perl distribution Sah-Schemas-Path), released on 2023-08-14.

=head1 SAH SCHEMAS

The following schemas are included in this distribution:

=over

=item * L<dirname|Sah::Schema::dirname>

Filesystem directory name.

This schema is basically string with some checks and prefilters. Why use this
schema instead of plain ol' str? Mainly to give you the ability to change tilde
to user's home directory, e.g. C<~/foo> into C</home/someuser/foo>. Normally this
expansion is done by a Unix shell, but sometimes your program receives an
unexpanded path, e.g. when you get it from some config file.

See also more OS-specific schemas like C<dirname::unix>, which adds some more
checks (e.g. filename cannot contain forward slash and each component cannot be
longer than 255 characters) and preprocessing (e.g. stripping extraneous slashes
like C<foo//bar> into C<foo/bar>.

What's the difference between this schema and C<filename>? The default completion
rule. This schema's completion by default only includes directories.


=item * L<dirname::exists|Sah::Schema::dirname::exists>

Directory name, must exist on filesystem.

=item * L<dirname::unix|Sah::Schema::dirname::unix>

Filesystem directory name on a Unix system.

=item * L<dirnames::exist|Sah::Schema::dirnames::exist>

List of directory names, all must exist on filesystem.

=item * L<filename|Sah::Schema::filename>

Filesystem file name.

This schema is basically string with some checks and prefilters. Why use this
schema instead of plain ol' str? Mainly to give you the ability to change tilde
to user's home directory, e.g. C<~/foo.txt> into C</home/someuser/foo.txt>.
Normally this expansion is done by a Unix shell, but sometimes your program
receives an unexpanded path, e.g. when you get it from some config file.

See also more OS-specific schemas like C<filename::unix>, which adds some more
checks (e.g. filename cannot contain forward slash and each component cannot be
longer than 255 characters) and preprocessing (e.g. stripping extraneous slashes
like C<foo//bar> into C<foo/bar>.

What's the difference between this schema and C<dirname>? The default completion
rule. This schema's completion by default only includes files and not
directories.


=item * L<filename::exists|Sah::Schema::filename::exists>

File name, must exist on filesystem.

=item * L<filename::unix|Sah::Schema::filename::unix>

Filesystem file name on a Unix system.

=item * L<filenames|Sah::Schema::filenames>

List of filesystem file names.

Coerces from string by expanding the glob pattern in the string.


=item * L<filenames::exist|Sah::Schema::filenames::exist>

List of file names, all must exist on filesystem.

=item * L<pathname|Sah::Schema::pathname>

Filesystem path name.

This schema is basically string with some checks and prefilters. Why use this
schema instead of plain ol' str? Mainly to give you the ability to change tilde
to user's home directory, e.g. C<~/foo> into C</home/someuser/foo>. Normally this
expansion is done by a Unix shell, but sometimes your program receives an
unexpanded path, e.g. when you get it from some config file.

See also more OS-specific schemas like C<pathname::unix>, which adds some more
checks (e.g. pathname cannot contain forward slash and each component cannot be
longer than 255 characters) and preprocessing (e.g. stripping extraneous slashes
like C<foo//bar> into C<foo/bar>.

What's the difference between this schema and C<filename> and C<dirname>? The
default completion rule. This schema's completion by default includes
files as well as directories.


=item * L<pathname::exists|Sah::Schema::pathname::exists>

Path name, must exist on filesystem.

=item * L<pathname::not_exists|Sah::Schema::pathname::not_exists>

Path name, must not already exist on filesystem.

=item * L<pathname::unix|Sah::Schema::pathname::unix>

Filesystem path name on a Unix system.

=item * L<pathnames|Sah::Schema::pathnames>

List of filesystem path names.

Coerces from string by expanding the glob pattern in the string.


=item * L<pathnames::exist|Sah::Schema::pathnames::exist>

List of path names, all must exist on filesystem.

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Path>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Path>.

=head1 SEE ALSO

L<Sah> - schema specification

L<Data::Sah> - Perl implementation of Sah

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTOR

=for stopwords Gabor Szabo

Gabor Szabo <gabor@szabgab.com>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2020, 2019, 2018, 2016 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Path>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
