package Pod::Weaver::Plugin::Acme::CPANLists;

our $DATE = '2015-10-22'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use Moose;
with 'Pod::Weaver::Role::AddTextToSection';
with 'Pod::Weaver::Role::Section';

use Markdown::To::POD;

sub _process_module {
    no strict 'refs';

    my ($self, $document, $input, $package) = @_;

    my $filename = $input->{filename};

    # XXX handle dynamically generated module (if there is such thing in the
    # future)
    local @INC = ("lib", @INC);

    {
        my $package_pm = $package;
        $package_pm =~ s!::!/!g;
        $package_pm .= ".pm";
        require $package_pm;
    }

    my $found;

    my $author_lists = \@{"$package\::Author_Lists"};
    for my $list (@$author_lists) {
        $found++;
        my $text = "=head2 $list->{summary}\n\n";
        $text .= Markdown::To::POD::markdown_to_pod($list->{description})."\n\n"
            if $list->{description};
        $text .= "=over\n\n";
        for my $ent (@{ $list->{entries} }) {
            $text .= "=item * L<".($ent->{summary} ? "$ent->{summary}|" : "$ent->{author}|")."https://metacpan.org/author/$ent->{author}>\n\n";
            $text .= Markdown::To::POD::markdown_to_pod($ent->{description})."\n\n"
                if $ent->{description};
        }
        $text .= "=back\n\n";
        $self->add_text_to_section($document, $text, 'AUTHOR LISTS');
    }

    my $module_lists = \@{"$package\::Module_Lists"};
    for my $list (@$module_lists) {
        $found++;
        my $text = "=head2 $list->{summary}\n\n";
        $text .= Markdown::To::POD::markdown_to_pod($list->{description})."\n\n"
            if $list->{description};
        $text .= "=over\n\n";
        for my $ent (@{ $list->{entries} }) {
            $text .= "=item * L<$ent->{module}>".($ent->{summary} ? " - $ent->{summary}" : "")."\n\n";
            $text .= Markdown::To::POD::markdown_to_pod($ent->{description})."\n\n"
                if $ent->{description};
        }
        $text .= "=back\n\n";
        $self->add_text_to_section($document, $text, 'MODULE LISTS');
    }

    if ($found) {
        $self->log(["Generated POD for '%s'", $filename]);
    }
}

sub weave_section {
    my ($self, $document, $input) = @_;

    my $filename = $input->{filename};

    my $package;
    if ($filename =~ m!^lib/(.+)\.pm$!) {
        $package = $1;
        $package =~ s!/!::!g;
        $self->_process_module($document, $input, $package);
    }
}

1;
# ABSTRACT: Create "AUTHOR LISTS" and "MODULE LISTS" POD sections from @Author_Lists and @Module_Lists

__END__

=pod

=encoding UTF-8

=head1 NAME

Pod::Weaver::Plugin::Acme::CPANLists - Create "AUTHOR LISTS" and "MODULE LISTS" POD sections from @Author_Lists and @Module_Lists

=head1 VERSION

This document describes version 0.03 of Pod::Weaver::Plugin::Acme::CPANLists (from Perl distribution Pod-Weaver-Plugin-Acme-CPANLists), released on 2015-10-22.

=head1 SYNOPSIS

In your C<weaver.ini>:

 [-Acme::CPANLists]

=head1 DESCRIPTION

=for Pod::Coverage weave_section

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Pod-Weaver-Plugin-Acme-CPANLists>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Pod-Weaver-Plugin-PERLANCAR-CPANLists>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Pod-Weaver-Plugin-Acme-CPANLists>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
