package Log::ger::Output::Callback;

our $DATE = '2017-07-03'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

sub get_hooks {
    my %conf = @_;

    my $hooks = {};

    if ($conf{logging_cb}) {
        $hooks->{create_log_routine} = [
            __PACKAGE__, 50,
            sub {
                my %args = @_;
                my $logger = sub {
                    $conf{logging_cb}->(@_);
                };
                [$logger];
            },
        ];
    }

    if ($conf{detection_cb}) {
        $hooks->{create_is_routine} = [
            __PACKAGE__, 50,
            sub {
                my %args = @_;
                my $logger = sub {
                    $conf{detection_cb}->($args{level});
                };
                [$logger];
            },
        ];
    }

    return $hooks;
}

1;
# ABSTRACT: Send logs to a subroutine

__END__

=pod

=encoding UTF-8

=head1 NAME

Log::ger::Output::Callback - Send logs to a subroutine

=head1 VERSION

This document describes version 0.001 of Log::ger::Output::Callback (from Perl distribution Log-ger-Output-Callback), released on 2017-07-03.

=head1 SYNOPSIS

 use Log::ger::Output Callback => (
     logging_cb   => sub { my ($ctx, $msg) = @_; ... }, # optional
     detection_cb => sub { my ($lvl) = @_; ... },       # optional
 );

=head1 DESCRIPTION

=for Pod::Coverage ^(.+)$

=head1 CONFIGURATION

=head1 logging_cb => code

=head1 detection_cb => code

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Log-ger-Output-Callback>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Log-ger-Output-Callback>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Log-ger-Output-Callback>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Log::ger>

Modelled after L<Log::Any::Adapter::Callback>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
