package Dist::Zilla::Plugin::Test::Rinci;

our $DATE = '2015-03-25'; # DATE
our $VERSION = '0.02'; # VERSION

use Moose;
extends 'Dist::Zilla::Plugin::InlineFiles';
with 'Dist::Zilla::Role::PrereqSource';

use namespace::autoclean;

# Register the release test prereq as a "develop requires"
# so it will be listed in "dzil listdeps --author"
sub register_prereqs {
  my ($self) = @_;

  $self->zilla->register_prereqs(
    {
      type  => 'requires',
      phase => 'develop',
    },
    'Test::Rinci' => '0.01',
  );
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: A release test for Rinci metadata

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Test::Rinci - A release test for Rinci metadata

=head1 VERSION

This document describes version 0.02 of Dist::Zilla::Plugin::Test::Rinci (from Perl distribution Dist-Zilla-Plugin-Test-Rinci), released on 2015-03-25.

=head1 DESCRIPTION

This is an extension of L<Dist::Zilla::Plugin::InlineFiles>, providing the
following files:

  xt/release/rinci.t - a standard Rinci metadata test

This test uses L<Test::Rinci> to check your Rinci metadata.

=for Pod::Coverage .+

=head1 ACKNOWLEDGEMENTS

Code based on L<Dist::Zilla::Plugin::PodCoverageTests> by RJBS.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-Test-Rinci>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Test-Rinci>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-Test-Rinci>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
___[ xt/release/rinci.t ]___
#!perl

# This file was automatically generated by Dist::Zilla::Plugin::Test::Rinci.

use Test::More;

eval "use Test::Rinci 0.01";
plan skip_all => "Test::Rinci 0.01 required for testing Rinci metadata"
  if $@;

metadata_in_all_modules_ok();
