package Data::Sah::Coerce::js::To_datetime::From_str::date_parse;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-21'; # DATE
our $DIST = 'Data-Sah-Coerce'; # DIST
our $VERSION = '0.048'; # VERSION

use 5.010001;
use strict;
use warnings;

use subroutines 'Data::Sah::Coerce::js::To_date::From_str::date_parse';

1;
# ABSTRACT: Coerce date from string using Date.parse()

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Sah::Coerce::js::To_datetime::From_str::date_parse - Coerce date from string using Date.parse()

=head1 VERSION

This document describes version 0.048 of Data::Sah::Coerce::js::To_datetime::From_str::date_parse (from Perl distribution Data-Sah-Coerce), released on 2020-05-21.

=head1 SYNOPSIS

To use in a Sah schema:

 ["datetime",{"x.perl.coerce_rules"=>["From_str::date_parse"]}]

=head1 DESCRIPTION

This will simply use JavaScript's C<Date.parse()>, but will throw an error when
date is invalid.

=for Pod::Coverage ^(meta|coerce)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Data-Sah-Coerce>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Data-Sah-Coerce>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Data-Sah-Coerce>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2018, 2017, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
