package DDD;

our $DATE = '2016-01-12'; # DATE
our $VERSION = '0.01'; # VERSION

use Data::Dump qw(dd);

sub import {
    my $class = shift;
    dd @_;
}

1;
# ABSTRACT: Dump data for debugging

__END__

=pod

=encoding UTF-8

=head1 NAME

DDD - Dump data for debugging

=head1 VERSION

This document describes version 0.01 of DDD (from Perl distribution DDD), released on 2016-01-12.

=head1 SYNOPSIS

 use DDD $your_data, $another, ...;

=head1 DESCRIPTION

L<DDD> is basically just a shortcut for:

 use Data::Dump; dd ...

except that it's shorter and you don't have to import anything.

It aids in print-based debugging session. You don't have to add a separate
C<use> statement.

=head1 SEE ALSO

L<XXX>, L<Data::Dump>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/DDD>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-DDD>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=DDD>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
