package Bencher::Scenario::RoleTinyCommonsTree::Startup;

our $DATE = '2016-07-03'; # DATE
our $VERSION = '0.03'; # VERSION

our $scenario = {
    summary => 'Benchmark startup overhead of some modules in '.
        'Role-TinyCommons-Tree distribution',
    module_startup => 1,
    modules => {
        'Code::Includable::Tree::NodeMethods'  => {version=>0.06},
        'Role::TinyCommons::Tree::NodeMethods' => {version=>0.06},
    },
    participants => [
        {module=>'Scalar::Util'},

        {module=>'Code::Includable::Tree::FromStruct'},
        {module=>'Code::Includable::Tree::NodeMethods'},

        {module=>'Role::TinyCommons::Tree::FromStruct'},
        {module=>'Role::TinyCommons::Tree::Node'},
        {module=>'Role::TinyCommons::Tree::NodeMethods'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of some modules in Role-TinyCommons-Tree distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RoleTinyCommonsTree::Startup - Benchmark startup overhead of some modules in Role-TinyCommons-Tree distribution

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::RoleTinyCommonsTree::Startup (from Perl distribution Bencher-Scenarios-RoleTinyCommonsTree), released on 2016-07-03.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RoleTinyCommonsTree::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Code::Includable::Tree::FromStruct> 0.10

L<Code::Includable::Tree::NodeMethods> 0.10

L<Role::TinyCommons::Tree::FromStruct> 0.10

L<Role::TinyCommons::Tree::Node> 0.10

L<Role::TinyCommons::Tree::NodeMethods> 0.10

L<Scalar::Util> 1.45

=head1 BENCHMARK PARTICIPANTS

=over

=item * Scalar::Util (perl_code)

L<Scalar::Util>



=item * Code::Includable::Tree::FromStruct (perl_code)

L<Code::Includable::Tree::FromStruct>



=item * Code::Includable::Tree::NodeMethods (perl_code)

L<Code::Includable::Tree::NodeMethods>



=item * Role::TinyCommons::Tree::FromStruct (perl_code)

L<Role::TinyCommons::Tree::FromStruct>



=item * Role::TinyCommons::Tree::Node (perl_code)

L<Role::TinyCommons::Tree::Node>



=item * Role::TinyCommons::Tree::NodeMethods (perl_code)

L<Role::TinyCommons::Tree::NodeMethods>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RoleTinyCommonsTree::Startup >>):

 #table1#
 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                          | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | Role::TinyCommons::Tree::FromStruct  |       9.2 |                    6.5 |        1   | 2.2e-05 |      21 |
 | Role::TinyCommons::Tree::NodeMethods |       8.7 |                    6   |        1.1 | 8.2e-05 |      20 |
 | Code::Includable::Tree::NodeMethods  |       6.3 |                    3.6 |        1.5 | 2.3e-05 |      21 |
 | Role::TinyCommons::Tree::Node        |       6.2 |                    3.5 |        1.5 | 3.8e-05 |      20 |
 | Scalar::Util                         |       6   |                    3.3 |        2   | 6.1e-05 |      20 |
 | Code::Includable::Tree::FromStruct   |       3.1 |                    0.4 |        3   | 1.8e-05 |      20 |
 | perl -e1 (baseline)                  |       2.7 |                    0   |        3.4 | 1.6e-05 |      20 |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RoleTinyCommonsTree>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RoleTinyCommonsTree>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RoleTinyCommonsTree>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
