package Bencher::Scenario::RoleTinyCommonsTree::descendants;

our $DATE = '2016-03-24'; # DATE
our $VERSION = '0.02'; # VERSION

use strict;
use warnings;

use Bencher::ScenarioUtil::RoleTinyCommonsTree qw(:all);

our $scenario = {
    summary => 'Benchmark descendants()',
    participants => [
        { fcall_template => 'Code::Includable::Tree::NodeMethods::descendants(<tree>)' },
    ],
    datasets => [
        {
            name=>'h3-o15',
            summary => 'A tree of height 3, 15 objects',
            args => { tree => $tree_h3_o15 },
        },
        {
            name=>'h4-o100',
            summary => 'A tree of height 4, 100 objects',
            args => { tree => $tree_h4_o100 },
        },
        {
            name=>'h6-o1k',
            summary => 'A tree of height 6, 1k objects',
            args => { tree => $tree_h6_o1k },
        },
        {
            name=>'h7-o20k',
            summary => 'A tree of height 7, ~20k objects',
            args => { tree => $tree_h7_o20k },
        },
    ],
};

1;
# ABSTRACT: Benchmark descendants()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RoleTinyCommonsTree::descendants - Benchmark descendants()

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::RoleTinyCommonsTree::descendants (from Perl distribution Bencher-Scenarios-RoleTinyCommonsTree), released on 2016-03-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RoleTinyCommonsTree::descendants

To run module startup overhead benchmark:

 % bencher --module-startup -m RoleTinyCommonsTree::descendants

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Code::Includable::Tree::NodeMethods> 0.07

=head1 BENCHMARK PARTICIPANTS

=over

=item * Code::Includable::Tree::NodeMethods::descendants (perl_code)

Function call template:

 Code::Includable::Tree::NodeMethods::descendants(<tree>)



=back

=head1 BENCHMARK DATASETS

=over

=item * h3-o15

A tree of height 3, 15 objects

=item * h4-o100

A tree of height 4, 100 objects

=item * h6-o1k

A tree of height 6, 1k objects

=item * h7-o20k

A tree of height 7, ~20k objects

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RoleTinyCommonsTree::descendants >>):

 +---------+-----------+-----------+------------+---------+---------+
 | dataset | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +---------+-----------+-----------+------------+---------+---------+
 | h7-o20k | 12.8      | 78.1      | 1          | 3.9e-05 | 22      |
 | h6-o1k  | 3.8e+02   | 2.7       | 29         | 1.7e-05 | 20      |
 | h4-o100 | 3.73e+03  | 0.268     | 291        | 2.1e-07 | 20      |
 | h3-o15  | 2.6e+04   | 0.039     | 2e+03      | 1.6e-07 | 21      |
 +---------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m RoleTinyCommonsTree::descendants --module-startup >>):

 +-------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-------------------------------------+-----------+------------------------+------------+---------+---------+
 | Code::Includable::Tree::NodeMethods | 17        | 3                      | 1          | 3.7e-05 | 20      |
 | perl -e1 (baseline)                 | 14        | 0                      | 1.2        | 3.9e-05 | 20      |
 +-------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RoleTinyCommonsTree>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RoleTinyCommonsTree>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RoleTinyCommonsTree>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
