package Bencher::Scenario::RegexpPattern::Startup;

our $DATE = '2016-09-14'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

#our @modules = do { require App::lcpan::Call; @{ App::lcpan::Call::call_lcpan_script(argv=>["modules", "--namespace", "Regexp::Pattern"])->[2] } }; # PRECOMPUTE
our @modules = qw(
                     Regexp::Pattern
                     Regexp::Pattern::RegexpCommon
                     Regexp::Pattern::YouTube
             );

our $scenario = {
    summary => 'Benchmark module startup overhead of Regexp::Pattern modules',

    module_startup => 1,

    participants => [
        map { +{module=>$_} } @modules,
    ],
};

1;
# ABSTRACT: Benchmark module startup overhead of Regexp::Pattern modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RegexpPattern::Startup - Benchmark module startup overhead of Regexp::Pattern modules

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::RegexpPattern::Startup (from Perl distribution Bencher-Scenarios-RegexpPattern), released on 2016-09-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RegexpPattern::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Regexp::Pattern> 0.1.2

L<Regexp::Pattern::RegexpCommon> 0.001

L<Regexp::Pattern::YouTube> 0.002

=head1 BENCHMARK PARTICIPANTS

=over

=item * Regexp::Pattern (perl_code)

L<Regexp::Pattern>



=item * Regexp::Pattern::RegexpCommon (perl_code)

L<Regexp::Pattern::RegexpCommon>



=item * Regexp::Pattern::YouTube (perl_code)

L<Regexp::Pattern::YouTube>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RegexpPattern::Startup >>):

 #table1#
 +-------------------------------+-----------+------------------------+------------+-----------+---------+
 | participant                   | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +-------------------------------+-----------+------------------------+------------+-----------+---------+
 | Regexp::Pattern::RegexpCommon |       9   |                    4   |        1   |   0.00013 |      20 |
 | Regexp::Pattern               |       7   |                    2   |        1   | 8.1e-05   |      21 |
 | perl -e1 (baseline)           |       5   |                    0   |        2   | 6.3e-05   |      21 |
 | Regexp::Pattern::YouTube      |       4.6 |                   -0.4 |        1.9 | 3.2e-05   |      20 |
 +-------------------------------+-----------+------------------------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RegexpPattern>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RegexpPattern>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RegexpPattern>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
