package Bencher::Scenario::PERLANCAR::pass_list_vs_array;

our $DATE = '2016-03-23'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark passing list vs array reference',
    description => <<'_',


_
    participants => [
        {
            name=>'pass_list',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }',
        },
        {
            name=>'pass_arrayref',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }',
        },
    ],

    datasets => [
        {name => 'data', args => {'size@'=>[100, 1000, 10000], 'reuse@'=>[1, 10, 100, 1000]}},
    ],
};

1;
# ABSTRACT: Benchmark passing list vs array reference

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::pass_list_vs_array - Benchmark passing list vs array reference

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::PERLANCAR::pass_list_vs_array (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-03-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::pass_list_vs_array

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * pass_list (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }



=item * pass_arrayref (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }



=back

=head1 BENCHMARK DATASETS

=over

=item * data

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::pass_list_vs_array >>):

 +---------------+-----------+----------+-----------+-----------+------------+---------+---------+
 | participant   | arg_reuse | arg_size | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +---------------+-----------+----------+-----------+-----------+------------+---------+---------+
 | pass_list     | 1000      | 10000    | 34.9      | 28.7      | 1          | 1.5e-05 | 20      |
 | pass_list     | 100       | 10000    | 3.2e+02   | 3.1       | 9.3        | 4.5e-06 | 20      |
 | pass_list     | 1000      | 1000     | 4e+02     | 2.5       | 12         | 7.1e-06 | 20      |
 | pass_list     | 10        | 10000    | 1.7e+03   | 0.58      | 50         | 1.1e-06 | 20      |
 | pass_arrayref | 1000      | 10000    | 2.37e+03  | 0.423     | 67.8       | 2e-07   | 23      |
 | pass_list     | 1000      | 100      | 3e+03     | 0.34      | 85         | 6.4e-07 | 20      |
 | pass_list     | 1         | 10000    | 3.14e+03  | 0.318     | 90         | 5.3e-08 | 20      |
 | pass_arrayref | 100       | 10000    | 3.28e+03  | 0.305     | 93.9       | 2e-07   | 22      |
 | pass_arrayref | 10        | 10000    | 3.4e+03   | 0.3       | 97         | 1.1e-06 | 21      |
 | pass_arrayref | 1         | 10000    | 3461.79   | 0.288868  | 99.1873    | 4.4e-11 | 20      |
 | pass_list     | 100       | 1000     | 3.6e+03   | 0.27      | 1e+02      | 4.8e-07 | 20      |
 | pass_arrayref | 1000      | 1000     | 6136.5    | 0.162959  | 175.823    | 4.5e-11 | 20      |
 | pass_arrayref | 1000      | 100      | 7303.33   | 0.136924  | 209.255    | 4.6e-11 | 20      |
 | pass_list     | 10        | 1000     | 1.8e+04   | 0.054     | 5.3e+02    | 1.3e-07 | 20      |
 | pass_arrayref | 100       | 1000     | 2.33e+04  | 0.0429    | 669        | 4e-08   | 20      |
 | pass_list     | 100       | 100      | 2.74e+04  | 0.0365    | 786        | 1.3e-08 | 20      |
 | pass_list     | 1         | 1000     | 3.1e+04   | 0.032     | 8.9e+02    | 1.7e-07 | 20      |
 | pass_arrayref | 10        | 1000     | 3.25e+04  | 0.0308    | 931        | 1e-08   | 33      |
 | pass_arrayref | 1         | 1000     | 3.39e+04  | 0.0295    | 972        | 1e-08   | 34      |
 | pass_arrayref | 100       | 100      | 59544     | 0.016794  | 1706.1     | 4.5e-11 | 20      |
 | pass_list     | 10        | 100      | 1.5e+05   | 0.0068    | 4.2e+03    | 9.8e-09 | 21      |
 | pass_arrayref | 10        | 100      | 2.1e+05   | 0.0048    | 6e+03      | 6.7e-09 | 20      |
 | pass_list     | 1         | 100      | 2.7e+05   | 0.0037    | 7.7e+03    | 5e-09   | 20      |
 | pass_arrayref | 1         | 100      | 2.783e+05 | 0.003593  | 7975       | 4.5e-11 | 20      |
 +---------------+-----------+----------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Passing a large array by reference will generate a large saving only if we reuse
the list (pass it multiple times).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
