package Bencher::Scenario::DateTimeFormatAlami::Parsing;

our $DATE = '2016-04-07'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark parsing speed of DateTime::Format::Alami against some other modules',
    participants => [
        {
            module=>'DateTime::Format::Alami::EN',
            code_template => 'state $parser = DateTime::Format::Alami::EN->new; $parser->parse_datetime(<text>)',
            tags => ['lang:en'],
        },
        {
            module=>'DateTime::Format::Alami::ID',
            code_template => 'state $parser = DateTime::Format::Alami::ID->new; $parser->parse_datetime(<text>)',
            tags => ['lang:id'],
        },
        {
            module=>'Date::Extract',
            code_template => 'state $parser = Date::Extract->new; $parser->extract(<text>)',
            tags => ['lang:en'],
        },
        {
            module=>'DateTime::Format::Natural',
            code_template => 'state $parser = DateTime::Format::Natural->new; $parser->parse_datetime(<text>)',
            tags => ['lang:en'],
        },
    ],
    datasets => [
        {args => {text => '18 feb'}},
        {args => {text => 'today'}, include_participant_tags => ['lang:en']},
        {args => {text => 'hari ini'}, include_participant_tags => ['lang:id']},
    ],
};

1;
# ABSTRACT: Benchmark parsing speed of DateTime::Format::Alami against some other modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DateTimeFormatAlami::Parsing - Benchmark parsing speed of DateTime::Format::Alami against some other modules

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::DateTimeFormatAlami::Parsing (from Perl distribution Bencher-Scenarios-DateTimeFormatAlami), released on 2016-04-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DateTimeFormatAlami::Parsing

To run module startup overhead benchmark:

 % bencher --module-startup -m DateTimeFormatAlami::Parsing

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<DateTime::Format::Alami::EN> 0.06

L<DateTime::Format::Alami::ID> 0.06

L<Date::Extract> 0.05

L<DateTime::Format::Natural> 1.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * DateTime::Format::Alami::EN (perl_code) [lang:en]

Code template:

 state $parser = DateTime::Format::Alami::EN->new; $parser->parse_datetime(<text>)



=item * DateTime::Format::Alami::ID (perl_code) [lang:id]

Code template:

 state $parser = DateTime::Format::Alami::ID->new; $parser->parse_datetime(<text>)



=item * Date::Extract (perl_code) [lang:en]

Code template:

 state $parser = Date::Extract->new; $parser->extract(<text>)



=item * DateTime::Format::Natural (perl_code) [lang:en]

Code template:

 state $parser = DateTime::Format::Natural->new; $parser->parse_datetime(<text>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 18 feb

=item * today

=item * hari ini

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m DateTimeFormatAlami::Parsing >>):

 +-----------------------------+----------+------------+-----------+------------+---------+---------+
 | participant                 | dataset  | rate (/s)  | time (μs) | vs_slowest | errors  | samples |
 +-----------------------------+----------+------------+-----------+------------+---------+---------+
 | Date::Extract               | 18 feb   | 791        | 1.26e+03  | 1          | 6.9e-07 | 20      |
 | DateTime::Format::Natural   | 18 feb   | 1.18e+03   | 845       | 1.5        | 4.8e-07 | 20      |
 | Date::Extract               | today    | 1.2e+03    | 832       | 1.52       | 2.7e-07 | 20      |
 | DateTime::Format::Natural   | today    | 2.4e+03    | 416       | 3.04       | 2.1e-07 | 20      |
 | DateTime::Format::Alami::EN | 18 feb   | 4.6e+03    | 2.2e+02   | 5.8        | 4.5e-07 | 23      |
 | DateTime::Format::Alami::ID | 18 feb   | 4.6e+03    | 217       | 5.82       | 2.1e-07 | 21      |
 | DateTime::Format::Alami::EN | today    | 9.8e+03    | 1e+02     | 12         | 2.1e-07 | 20      |
 | DateTime::Format::Alami::ID | hari ini | 1.1547e+05 | 8.6604    | 145.94     | 2.9e-11 | 20      |
 +-----------------------------+----------+------------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DateTimeFormatAlami::Parsing --module-startup >>):

 +-----------------------------+-----------+------------------------+------------+---------+---------+
 | participant                 | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-----------------------------+-----------+------------------------+------------+---------+---------+
 | Date::Extract               | 71.5      | 66.3                   | 1          | 4.4e-05 | 20      |
 | DateTime::Format::Natural   | 70.4      | 65.2                   | 1.02       | 2.8e-05 | 20      |
 | DateTime::Format::Alami::EN | 16        | 10.8                   | 4.4        | 2.1e-05 | 20      |
 | DateTime::Format::Alami::ID | 16        | 10.8                   | 4.5        | 2.7e-05 | 21      |
 | perl -e1 (baseline)         | 5.2       | 0                      | 14         | 7.2e-06 | 21      |
 +-----------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DateTimeFormatAlami>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DateTimeFormatAlami>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DateTimeFormatAlami>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
