package Bencher::Scenario::DateModules::Storage;

our $DATE = '2017-08-27'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Measure memory storage usage of 1k date/duration objects/structures',
    precision => 1,
    participants => [
        {
            name => 'DateTime',
            module => 'DateTime',
            code_template => '[map {DateTime->new(year=>2016, month=>4, day=>19)} 1..1_000]',
        },
        {
            name => 'DateTime::Tiny',
            module => 'DateTime::Tiny',
            code_template => '[map {DateTime::Tiny->new(year=>2016, month=>4, day=>19)} 1..1_000]',
        },
        {
            name => 'Time::Moment',
            module => 'Time::Moment',
            code_template => '[map {Time::Moment->new(year=>2016, month=>4, day=>19)} 1..1_000]',
        },
        {
            name => 'Time::Local',
            module => 'Time::Local',
            code_template => '[map {Time::Local::timelocal(0, 0, 0, 19, 4-1, 2016-1900)} 1..1_000]',
        },
        {
            name => 'Time::Piece',
            module => 'Time::Piece',
            code_template => '[map {Time::Piece::localtime()} 1..1_000]',
        },

        {
            name => 'DateTime::Duration',
            module => 'DateTime::Duration',
            code_template => '[map {DateTime::Duration->new(months=>1, days=>2, minutes=>3, seconds=>4, nanoseconds=>5)} 1..1_000]',
        },

    ],

    with_result_size => 1,
};

1;
# ABSTRACT: Measure memory storage usage of 1k date/duration objects/structures

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DateModules::Storage - Measure memory storage usage of 1k date/duration objects/structures

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::DateModules::Storage (from Perl distribution Bencher-Scenarios-DateModules), released on 2017-08-27.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DateModules::Storage

To run module startup overhead benchmark:

 % bencher --module-startup -m DateModules::Storage

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<DateTime> 1.36

L<DateTime::Tiny> 1.06

L<Time::Moment> 0.38

L<Time::Local> 1.2300

L<Time::Piece> 1.31

L<DateTime::Duration> 1.36

=head1 BENCHMARK PARTICIPANTS

=over

=item * DateTime (perl_code)

Code template:

 [map {DateTime->new(year=>2016, month=>4, day=>19)} 1..1_000]



=item * DateTime::Tiny (perl_code)

Code template:

 [map {DateTime::Tiny->new(year=>2016, month=>4, day=>19)} 1..1_000]



=item * Time::Moment (perl_code)

Code template:

 [map {Time::Moment->new(year=>2016, month=>4, day=>19)} 1..1_000]



=item * Time::Local (perl_code)

Code template:

 [map {Time::Local::timelocal(0, 0, 0, 19, 4-1, 2016-1900)} 1..1_000]



=item * Time::Piece (perl_code)

Code template:

 [map {Time::Piece::localtime()} 1..1_000]



=item * DateTime::Duration (perl_code)

Code template:

 [map {DateTime::Duration->new(months=>1, days=>2, minutes=>3, seconds=>4, nanoseconds=>5)} 1..1_000]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m DateModules::Storage >>):

 #table1#
 +--------------------+-----------+-----------+------------+------------------+--------+---------+
 | participant        | rate (/s) | time (ms) | vs_slowest | result_size (MB) | errors | samples |
 +--------------------+-----------+-----------+------------+------------------+--------+---------+
 | DateTime           |   27.555  | 36.2911   |    1       |        1.48492   |      0 |       1 |
 | DateTime::Duration |   54.5496 | 18.3319   |    1.97966 |        0.507655  |      0 |       1 |
 | Time::Local        |  108.414  |  9.22388  |    3.93447 |        0.0610962 |      0 |       1 |
 | Time::Piece        |  180.185  |  5.54985  |    6.53911 |        0.274719  |      0 |       1 |
 | DateTime::Tiny     | 1512.69   |  0.661074 |   54.8971  |        0.282457  |      0 |       1 |
 | Time::Moment       | 2597.5    |  0.384985 |   94.266   |        0.116409  |      0 |       1 |
 +--------------------+-----------+-----------+------------+------------------+--------+---------+


Benchmark module startup overhead (C<< bencher -m DateModules::Storage --module-startup >>):

 #table2#
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+--------+---------+
 | participant         | proc_private_dirty_size (MB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest | errors | samples |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+--------+---------+
 | DateTime            | 1.04297                      | 4.44922            | 16.1328        |  61.685   |               55.24704 |    1       |      0 |       1 |
 | DateTime::Duration  | 0.824219                     | 4.13672            | 16.0078        |  60.6028  |               54.16484 |    1.01786 |      0 |       1 |
 | Time::Piece         | 11.0039                      | 14.875             | 44.3125        |  18.66    |               12.22204 |    3.30573 |      0 |       1 |
 | Time::Local         | 2.28125                      | 5.91016            | 19.4492        |  14.5449  |                8.10694 |    4.24101 |      0 |       1 |
 | Time::Moment        | 1.51953                      | 5.01953            | 16.6523        |  12.7539  |                6.31594 |    4.83656 |      0 |       1 |
 | DateTime::Tiny      | 1.35938                      | 4.79688            | 18.6016        |   9.90814 |                3.47018 |    6.22569 |      0 |       1 |
 | perl -e1 (baseline) | 11.0977                      | 14.9531            | 44.4609        |   6.43796 |                0       |    9.58146 |      0 |       1 |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+--------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DateModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DateModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DateModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
