package Bencher::Scenario::DataSah::gen_validator;

our $DATE = '2016-05-20'; # DATE
our $VERSION = '0.06'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validator generation',
    participants => [
        {
            name => 'gen_validator',
            fcall_template => 'Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})',
        },
    ],
    datasets => [
        {args => {'return_type@' => $return_types, schema => 'str'}},
        {args => {'return_type@' => $return_types, schema => 'str*'}},
        {args => {'return_type@' => $return_types, schema => ['str', len=>8]}},
        {args => {'return_type@' => $return_types, schema => ['str', min_len=>1, max_len=>10]}},
        {args => {'return_type@' => $return_types, schema => 'date'}},
        {args => {'return_type@' => $return_types, schema => ['array', of=>['str', min_len=>1, max_len=>10]]}},
        {args => {'return_type@' => $return_types, schema => ['array', elems=>['int*', 'str*', 'float*', 're*']]}},
    ],
};

1;
# ABSTRACT: Benchmark validator generation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::gen_validator - Benchmark validator generation

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::DataSah::gen_validator (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::gen_validator

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::gen_validator

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah> 0.77

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Function call template:

 Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})



=back

=head1 BENCHMARK DATASETS

=over

=item * str

=item * str*

=item * ["str","len",8]

=item * ["str","min_len",1,"max_len",10]

=item * date

=item * ["array","of",["str","min_len",1,"max_len",10]]

=item * ["array","elems",["int*","str*","float*","re*"]]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::gen_validator >>):

 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | dataset                                          | arg_return_type | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | ["array","elems",["int*","str*","float*","re*"]] | full            | 1.8e+02   | 5.4       | 1          | 4.4e-05 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | str             | 1.9e+02   | 5.3       | 1          | 4.9e-05 | 20      |
 | ["array","elems",["int*","str*","float*","re*"]] | bool            | 2.1e+02   | 4.7       | 1.2        | 3.8e-05 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | full            | 3.6e+02   | 2.8       | 2          | 2.1e-05 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | str             | 3.7e+02   | 2.7       | 2          | 1.8e-05 | 20      |
 | ["array","of",["str","min_len",1,"max_len",10]]  | bool            | 4e+02     | 2.5       | 2.2        | 2.2e-05 | 20      |
 | ["str","min_len",1,"max_len",10]                 | full            | 6.6e+02   | 1.5       | 3.6        | 8.2e-06 | 24      |
 | ["str","min_len",1,"max_len",10]                 | str             | 6.9e+02   | 1.5       | 3.7        | 8.1e-06 | 21      |
 | ["str","min_len",1,"max_len",10]                 | bool            | 7.6e+02   | 1.3       | 4.1        | 5.1e-06 | 20      |
 | date                                             | full            | 7.9e+02   | 1.3       | 4.3        | 6.3e-06 | 20      |
 | ["str","len",8]                                  | str             | 8.1e+02   | 1.2       | 4.4        | 7.4e-06 | 20      |
 | ["str","len",8]                                  | full            | 8.1e+02   | 1.2       | 4.4        | 3.8e-06 | 20      |
 | date                                             | str             | 8.2e+02   | 1.2       | 4.4        | 8.7e-06 | 20      |
 | ["str","len",8]                                  | bool            | 8e+02     | 1         | 5          | 2.2e-05 | 20      |
 | date                                             | bool            | 925       | 1.08      | 5.04       | 6.9e-07 | 20      |
 | str*                                             | full            | 9.4e+02   | 1.1       | 5.1        | 4e-06   | 20      |
 | str*                                             | str             | 9.5e+02   | 1.1       | 5.2        | 8.5e-06 | 20      |
 | str                                              | full            | 1e+03     | 1         | 6          | 1e-05   | 20      |
 | str*                                             | bool            | 1.1e+03   | 0.94      | 5.8        | 4.9e-06 | 20      |
 | str                                              | str             | 1.1e+03   | 0.87      | 6.2        | 1.9e-06 | 22      |
 | str                                              | bool            | 1.2e+03   | 0.85      | 6.4        | 5.4e-06 | 20      |
 +--------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataSah::gen_validator --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::Sah           | 12        | 7.2                    | 1          | 4e-05   | 20      |
 | perl -e1 (baseline) | 4.8       | 0                      | 2.5        | 2.1e-05 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
