package Bencher::Scenario::DataSah::Startup;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use FindBin '$Bin';

# XXX replace $^X with perl path provided by bencher

our $scenario = {
    summary => 'Benchmark startup overhead of loading Data::Sah and generating validators',
    participants => [
        { name => 'perl',              cmdline => [$^X, "-I$Bin/..lib", "-e1"] },
        { name => 'load_dsah',         cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah", "-e", 1] },
        { name => 'load_dsah+get_plc', cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah", "-e", '$sah = Data::Sah->new; $plc = $sah->get_compiler("perl")'] },
        { name => 'gen_bool_val_int',  cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'gen_validator("int")'] },
        { name => 'gen_str_val_int',   cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'gen_validator("int",{return_type=>"str"})'] },
        { name => 'gen_str_vals',      cmdline => [$^X, "-I$Bin/..lib", "-MData::Sah=gen_validator", "-e", 'for ("int", "str*", [int=>min=>1, max=>10], [str, min_len=>4], [any=>of=>["str",["array",of=>"str"]]]) { gen_validator("int",{return_type=>"str"}) }'] },
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of loading Data::Sah and generating validators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Startup

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::DataSah::Startup (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * perl (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -e1



=item * load_dsah (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -MData::Sah -e 1



=item * load_dsah+get_plc (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -MData::Sah -e $sah = Data::Sah->new; $plc = $sah->get_compiler("perl")



=item * gen_bool_val_int (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -MData::Sah=gen_validator -e gen_validator("int")



=item * gen_str_val_int (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -MData::Sah=gen_validator -e gen_validator("int",{return_type=>"str"})



=item * gen_str_vals (command)

Command line:

 /zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/perl -I/zpool_host_mnt/mnt/home/s1/perl5/perlbrew/perls/perl-5.22.0/bin/..lib -MData::Sah=gen_validator -e for ("int", "str*", [int=>min=>1, max=>10], [str, min_len=>4], [any=>of=>["str",["array",of=>"str"]]]) { gen_validator("int",{return_type=>"str"}) }



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-------------------+-------+--------+---------+---------+
 | seq | name              | rate  | time   | errors  | samples |
 +-----+-------------------+-------+--------+---------+---------+
 | 5   | gen_str_vals      | 17    | 58ms   | 0.00043 | 20      |
 | 4   | gen_str_val_int   | 18    | 55ms   | 0.00046 | 20      |
 | 3   | gen_bool_val_int  | 19    | 52.6ms | 9.9e-05 | 21      |
 | 2   | load_dsah+get_plc | 33    | 30ms   | 0.00017 | 22      |
 | 1   | load_dsah         | 85    | 12ms   | 7.4e-05 | 20      |
 | 0   | perl              | 2e+02 | 5.1ms  | 4.2e-05 | 20      |
 +-----+-------------------+-------+--------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
