package Bencher::Scenario::ArraySet::symdiff;

our $DATE = '2016-09-16'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark symmetric difference operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_symdiff(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'symmetric_difference',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->symmetric_difference($set2);', # $res->as_string
        },
        {
            module => 'Set::Scalar',
            function => 'symmetric_difference',
            code_template => 'my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->symmetric_difference($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[3..7] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[96..105] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[996..1005] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[951..1050] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark symmetric difference operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::symdiff - Benchmark symmetric difference operation

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::ArraySet::symdiff (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::symdiff

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::symdiff

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.05

L<Set::Object> 1.35

L<Set::Scalar> 1.29

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_symdiff (perl_code)

Function call template:

 Array::Set::set_symdiff(<set1>, <set2>)



=item * Set::Object::symmetric_difference (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->symmetric_difference($set2);



=item * Set::Scalar::symmetric_difference (perl_code)

Code template:

 my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->symmetric_difference($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m ArraySet::symdiff --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.05/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |       320 |     3.13  |       1    | 2.4e-06 |      21 |
 | Set::Scalar::symmetric_difference |        |       426 |     2.35  |       1.33 | 1.8e-06 |      20 |
 | Set::Object::symmetric_difference |        |      1070 |     0.934 |       3.35 | 6.9e-07 |      20 |
 | Array::Set::set_symdiff           | 0.05   |      1850 |     0.541 |       5.77 | 4.8e-07 |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |       315 |      3.18 |        1   |   2e-06 |      20 |
 | Set::Scalar::symmetric_difference |        |       420 |      2.4  |        1.3 | 2.5e-06 |      20 |
 | Set::Object::symmetric_difference |        |      1000 |      1    |        3.2 | 6.3e-06 |      21 |
 | Array::Set::set_symdiff           | 0.05   |      1800 |      0.55 |        5.8 | 6.4e-07 |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |       284 |     3.52  |       1    | 6.9e-07 |      20 |
 | Set::Scalar::symmetric_difference |        |       380 |     2.6   |       1.3  | 3.1e-06 |      20 |
 | Set::Object::symmetric_difference |        |       970 |     1.03  |       3.42 | 4.3e-07 |      20 |
 | Array::Set::set_symdiff           | 0.05   |      1690 |     0.592 |       5.95 | 4.8e-07 |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |       155 |     6.43  |       1    |   2e-06 |      20 |
 | Set::Scalar::symmetric_difference |        |       250 |     4     |       1.6  | 4.9e-06 |      20 |
 | Set::Object::symmetric_difference |        |       824 |     1.21  |       5.3  | 5.9e-07 |      20 |
 | Array::Set::set_symdiff           | 0.05   |      1370 |     0.728 |       8.84 | 2.5e-07 |      22 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |      3000 |     330   |       1    | 4.3e-07 |      20 |
 | Set::Scalar::symmetric_difference |        |      3680 |     272   |       1.21 | 2.1e-07 |      20 |
 | Set::Object::symmetric_difference |        |     10000 |     100   |       3.3  | 1.3e-07 |      20 |
 | Array::Set::set_symdiff           | 0.05   |     21600 |      46.2 |       7.11 | 1.3e-08 |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |      2750 |     364   |       1    | 1.9e-07 |      24 |
 | Set::Scalar::symmetric_difference |        |      3380 |     296   |       1.23 | 2.5e-07 |      22 |
 | Set::Object::symmetric_difference |        |      9100 |     110   |       3.3  | 2.2e-07 |      29 |
 | Array::Set::set_symdiff           | 0.05   |     20200 |      49.4 |       7.37 | 3.7e-08 |      23 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_symdiff           | 0.02   |      1540 |       650 |       1    | 2.5e-07 |      22 |
 | Set::Scalar::symmetric_difference |        |      2360 |       424 |       1.53 | 1.9e-07 |      24 |
 | Set::Object::symmetric_difference |        |      8200 |       120 |       5.3  | 2.1e-07 |      21 |
 | Array::Set::set_symdiff           | 0.05   |     16000 |        62 |      11    | 9.9e-08 |      23 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::symmetric_difference |        |   16833.4 |   59.4056 |        1   | 5.8e-11 |      25 |
 | Array::Set::set_symdiff           | 0.02   |   25000   |   40      |        1.5 | 4.4e-08 |      30 |
 | Set::Object::symmetric_difference |        |   60000   |   17      |        3.5 | 2.7e-08 |      20 |
 | Array::Set::set_symdiff           | 0.05   |  150000   |    6.8    |        8.7 | 9.3e-09 |      23 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::symmetric_difference |        |     14000 |  73       |    1       | 9.7e-08 |      24 |
 | Array::Set::set_symdiff           | 0.02   |     14200 |  70.6     |    1.03    | 2.7e-08 |      20 |
 | Set::Object::symmetric_difference |        |     54600 |  18.32    |    3.964   | 3.1e-10 |      25 |
 | Array::Set::set_symdiff           | 0.05   |    125915 |   7.94185 |    9.14294 |   0     |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::symmetric_difference |        |     15000 |   66      |    1       |   1e-07 |      33 |
 | Array::Set::set_symdiff           | 0.02   |     18358 |   54.4723 |    1.21645 | 4.3e-11 |      20 |
 | Set::Object::symmetric_difference |        |     56600 |   17.7    |    3.75    | 6.7e-09 |      20 |
 | Array::Set::set_symdiff           | 0.05   |    136000 |    7.36   |    9       | 2.6e-09 |      32 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                       | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::symmetric_difference |        |     27100 |      36.8 |        1   | 1.3e-08 |      20 |
 | Array::Set::set_symdiff           | 0.02   |     91000 |      11   |        3.3 | 1.1e-08 |      27 |
 | Set::Object::symmetric_difference |        |    120000 |       8.3 |        4.5 | 1.3e-08 |      20 |
 | Array::Set::set_symdiff           | 0.05   |    350000 |       2.8 |       13   | 3.3e-09 |      20 |
 +-----------------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::symdiff --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Set::Object         |      17   |                   12.5 |        1   | 9.3e-05 |      20 |
 | Set::Scalar         |      15   |                   10.5 |        1.1 | 2.8e-05 |      21 |
 | Array::Set          |       8   |                    3.5 |        2.1 | 3.2e-05 |      20 |
 | perl -e1 (baseline) |       4.5 |                    0   |        3.7 | 8.5e-06 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
