package Bencher::Scenario::Accessors::Set;

our $DATE = '2016-04-14'; # DATE
our $VERSION = '0.06'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute write/set',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o }; \$o->{attr1} = 42",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o }; \$o->[0] = 42",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute write/set

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Set - Benchmark attribute write/set

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::Accessors::Set (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-04-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Set

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Set

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.05

L<Perl::Examples::Accessors::ClassAccessor> 0.05

L<Perl::Examples::Accessors::ClassAccessorArray> 0.05

L<Perl::Examples::Accessors::ClassInsideOut> 0.05

L<Perl::Examples::Accessors::ClassXSAccessor> 0.05

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.05

L<Perl::Examples::Accessors::Hash> 0.05

L<Perl::Examples::Accessors::Mo> 0.05

L<Perl::Examples::Accessors::MojoBase> 0.05

L<Perl::Examples::Accessors::Moo> 0.05

L<Perl::Examples::Accessors::Moose> 0.05

L<Perl::Examples::Accessors::Mouse> 0.05

L<Perl::Examples::Accessors::ObjectSimple> 0.05

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o }; $o->attr1(42)



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->{attr1} = 42



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->[0] = 42



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Set >>):

 +----------------------------+-------------+-----------+------------+---------+---------+
 | participant                | rate (/s)   | time (ns) | vs_slowest | errors  | samples |
 +----------------------------+-------------+-----------+------------+---------+---------+
 | Class::Accessor            | 1.8e+06     | 5.5e+02   | 1          | 6.2e-10 | 20      |
 | Class::InsideOut           | 3.04133e+06 | 328.803   | 1.67054    | 0       | 20      |
 | no generator (hash-based)  | 4.5e+06     | 222       | 2.47       | 1e-10   | 20      |
 | no generator (array-based) | 4.95e+06    | 202       | 2.72       | 1e-10   | 20      |
 | Mojo::Base                 | 5.1e+06     | 1.9e+02   | 2.8        | 4.1e-10 | 21      |
 | Moose                      | 5.20602e+06 | 192.085   | 2.85956    | 0       | 20      |
 | Mo                         | 5.37543e+06 | 186.032   | 2.95261    | 0       | 20      |
 | Class::Accessor::Array     | 5.64654e+06 | 177.099   | 3.10153    | 0       | 22      |
 | Object::Simple             | 5.73427e+06 | 174.39    | 3.14972    | 0       | 20      |
 | Mouse                      | 8.5e+06     | 118       | 4.67       | 5.2e-11 | 20      |
 | Class::XSAccessor          | 1.2e+07     | 81        | 6.8        | 2.1e-10 | 20      |
 | Moo                        | 1.27e+07    | 78.8      | 6.97       | 5.2e-11 | 20      |
 | Class::XSAccessor::Array   | 1.4e+07     | 69        | 7.9        | 1.8e-10 | 27      |
 | raw hash access            | 2.2e+07     | 45        | 12         | 1.5e-10 | 37      |
 | raw array access           | 2.72783e+07 | 36.6592   | 14.9834    | 0       | 20      |
 +----------------------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
