package Bencher::Scenario::SortBySpec;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Sort::BySpec (e.g. against Sort::ByExample, etc)',
    participants => [
        {
            name => 'gen_sorter-sbe',
            tags => ['gen_sorter', 'sbe'],
            module => 'Sort::ByExample',
            code_template => 'Sort::ByExample::sbe(<spec>)',
        },
        {
            name => 'gen_sorter-sbs',
            tags => ['gen_sorter', 'sbs'],
            module => 'Sort::BySpec',
            code_template => 'Sort::BySpec::sort_by_spec(spec => <spec>)',
        },

        {
            name => 'sort-sbe',
            tags => ['sort', 'sbe'],
            module => 'Sort::ByExample',
            code_template => 'state $sorter = Sort::ByExample::sbe(<spec>); [$sorter->(@{<list>})]',
        },
        {
            name => 'sort-sbs',
            tags => ['sort', 'sbs'],
            module => 'Sort::BySpec',
            code_template => 'state $sorter = Sort::BySpec::sort_by_spec(spec => <spec>); [$sorter->(@{<list>})]',
        },
    ],

    datasets => [
        {
            name => 'eg-num5-list10',
            args => {
                spec => [5,4,3,2,1],
                # currently unwieldy, need to use hash
                #'list@' => [
                #    [1..10],  # 10-elem
                #    [1..100], # 100-elem
                #],
                'list' => [1..10],
            },
        },
        {
            name => 'eg-num5-list100',
            args => {
                spec => [5,4,3,2,1],
                'list' => [1..100],
            },
        },
        {
            name => 'eg-num5-list1000',
            args => {
                spec => [5,4,3,2,1],
                'list' => [1..1000],
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark Sort::BySpec (e.g. against Sort::ByExample, etc)

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SortBySpec

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::SortBySpec (from Perl distribution Bencher-Scenario-SortBySpec), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SortBySpec

To run module startup overhead benchmark:

 % bencher --module-startup -m SortBySpec

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Sort::ByExample> 0.007

L<Sort::BySpec> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_sorter-sbe (perl_code)

Code template:

 Sort::ByExample::sbe(<spec>)



=item * gen_sorter-sbs (perl_code)

Code template:

 Sort::BySpec::sort_by_spec(spec => <spec>)



=item * sort-sbe (perl_code)

Code template:

 state $sorter = Sort::ByExample::sbe(<spec>); [$sorter->(@{<list>})]



=item * sort-sbs (perl_code)

Code template:

 state $sorter = Sort::BySpec::sort_by_spec(spec => <spec>); [$sorter->(@{<list>})]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-------------------------------------------------------------+------------+-------------+---------+---------+
 | seq | name                                                        | rate       | time        | errors  | samples |
 +-----+-------------------------------------------------------------+------------+-------------+---------+---------+
 | 11  | {dataset=>"eg-num5-list1000",participant=>"sort-sbs"}       | 163        | 6.14ms      | 4.2e-06 | 20      |
 | 10  | {dataset=>"eg-num5-list100",participant=>"sort-sbs"}        | 1.68e+03   | 0.596ms     | 2.7e-07 | 20      |
 | 8   | {dataset=>"eg-num5-list1000",participant=>"sort-sbe"}       | 2062.038   | 0.4849571ms | 9.1e-11 | 20      |
 | 7   | {dataset=>"eg-num5-list100",participant=>"sort-sbe"}        | 19396.2    | 0.0515566ms | 9.2e-11 | 32      |
 | 9   | {dataset=>"eg-num5-list10",participant=>"sort-sbs"}         | 2.25e+04   | 0.0445ms    | 4e-08   | 20      |
 | 6   | {dataset=>"eg-num5-list10",participant=>"sort-sbe"}         | 9.5e+04    | 0.0105ms    | 1.3e-08 | 20      |
 | 0   | {dataset=>"eg-num5-list10",participant=>"gen_sorter-sbe"}   | 1.41e+05   | 0.00711ms   | 1.7e-08 | 20      |
 | 2   | {dataset=>"eg-num5-list1000",participant=>"gen_sorter-sbe"} | 1.4092e+05 | 0.0070962ms | 9.2e-11 | 20      |
 | 1   | {dataset=>"eg-num5-list100",participant=>"gen_sorter-sbe"}  | 1.42e+05   | 0.00706ms   | 3.3e-09 | 20      |
 | 5   | {dataset=>"eg-num5-list1000",participant=>"gen_sorter-sbs"} | 2.17e+05   | 0.00461ms   | 1.6e-09 | 21      |
 | 4   | {dataset=>"eg-num5-list100",participant=>"gen_sorter-sbs"}  | 2.18e+05   | 0.00459ms   | 5.7e-09 | 27      |
 | 3   | {dataset=>"eg-num5-list10",participant=>"gen_sorter-sbs"}   | 2.18e+05   | 0.00459ms   | 6.7e-09 | 20      |
 +-----+-------------------------------------------------------------+------------+-------------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------+--------+-------------------+---------+---------+
 | seq | name                | time   | mod_overhead_time | errors  | samples |
 +-----+---------------------+--------+-------------------+---------+---------+
 | 1   | Sort::ByExample     | 20ms   | 16ms              | 9e-05   | 20      |
 | 2   | Sort::BySpec        | 8.06ms | 3.53ms            | 1.7e-05 | 20      |
 | 0   | perl -e1 (baseline) | 4.5ms  | 0ms               | 2.7e-05 | 20      |
 +-----+---------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-SortBySpec>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-SortBySpec>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-SortBySpec>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
