package Bencher::Scenario::PermuteNamedModules;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various modules doing permutation of multiple-valued key-value pairs',
    participants => [
        {
            module => "PERLANCAR::Permute::Named",
            code => sub {
                my @res = PERLANCAR::Permute::Named::permute_named(@_);
            },
        },
        {
            module => "Permute::Named",
            code => sub {
                my @res = Permute::Named::permute_named(@_);
            },
        },
        {
            module => "Permute::Named::Iter",
            code => sub {
                my $iter = Permute::Named::Iter::permute_named_iter(@_);
                my @res;
                while (my $h = $iter->()) { push @res, $h }
            },
        },
    ],
    datasets => [
        {argv=>[a=>[1,2], b=>[1,2,3]], name=>'small (2x3=6)'},
        {argv=>[a=>[1,2], b=>[1..50]], name=>'long (2x50=100)'},
        {argv=>[a=>[1,2], a=>[1,2], c=>[1,2], d=>[1,2], e=>[1,2], f=>[1,2], g=>[1,2], h=>[1,2], i=>[1,2], j=>[1,2]], name=>'wide (2**10=1k)'},
        {argv=>[a=>[1..10], b=>[1..10], c=>[1..10], d=>[1..2], e=>[1..2], f=>[1..3]], name=>'large (10x10x10x2x2x3=12ki)'},
    ],
};

1;
# ABSTRACT: Benchmark various modules doing permutation of multiple-valued key-value pairs

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PermuteNamedModules

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::PermuteNamedModules (from Perl distribution Bencher-Scenario-PermuteNamedModules), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PermuteNamedModules

To run module startup overhead benchmark:

 % bencher --module-startup -m PermuteNamedModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<PERLANCAR::Permute::Named> 0.02

L<Permute::Named> 1.100980

L<Permute::Named::Iter> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Permute::Named (perl_code)

L<PERLANCAR::Permute::Named>



=item * Permute::Named (perl_code)

L<Permute::Named>



=item * Permute::Named::Iter (perl_code)

L<Permute::Named::Iter>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-----------------------------------------------------------------------------------+----------+----------+---------+---------+
 | seq | name                                                                              | rate     | time     | errors  | samples |
 +-----+-----------------------------------------------------------------------------------+----------+----------+---------+---------+
 | 7   | {dataset=>"large (10x10x10x2x2x3=12ki)",participant=>"Permute::Named"}            | 7.17     | 140ms    | 0.00018 | 20      |
 | 11  | {dataset=>"large (10x10x10x2x2x3=12ki)",participant=>"Permute::Named::Iter"}      | 26.6     | 37.6ms   | 3.6e-05 | 20      |
 | 3   | {dataset=>"large (10x10x10x2x2x3=12ki)",participant=>"PERLANCAR::Permute::Named"} | 26.6     | 37.6ms   | 5.6e-05 | 20      |
 | 6   | {dataset=>"wide (2**10=1k)",participant=>"Permute::Named"}                        | 57.1     | 17.5ms   | 1.4e-05 | 21      |
 | 2   | {dataset=>"wide (2**10=1k)",participant=>"PERLANCAR::Permute::Named"}             | 193      | 5.17ms   | 8.9e-06 | 21      |
 | 10  | {dataset=>"wide (2**10=1k)",participant=>"Permute::Named::Iter"}                  | 208      | 4.81ms   | 2.7e-06 | 20      |
 | 5   | {dataset=>"long (2x50=100)",participant=>"Permute::Named"}                        | 2.17e+03 | 0.46ms   | 4.3e-07 | 20      |
 | 1   | {dataset=>"long (2x50=100)",participant=>"PERLANCAR::Permute::Named"}             | 4.84e+03 | 0.207ms  | 4.1e-07 | 22      |
 | 9   | {dataset=>"long (2x50=100)",participant=>"Permute::Named::Iter"}                  | 5.58e+03 | 0.179ms  | 2.7e-07 | 20      |
 | 0   | {dataset=>"small (2x3=6)",participant=>"PERLANCAR::Permute::Named"}               | 1.5e+04  | 0.069ms  | 2.4e-07 | 20      |
 | 4   | {dataset=>"small (2x3=6)",participant=>"Permute::Named"}                          | 1.62e+04 | 0.0616ms | 1.1e-07 | 20      |
 | 8   | {dataset=>"small (2x3=6)",participant=>"Permute::Named::Iter"}                    | 5.05e+04 | 0.0198ms | 4.8e-08 | 25      |
 +-----+-----------------------------------------------------------------------------------+----------+----------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------------+--------+-------------------+---------+---------+
 | seq | name                      | time   | mod_overhead_time | errors  | samples |
 +-----+---------------------------+--------+-------------------+---------+---------+
 | 2   | Permute::Named            | 20.2ms | 10.3ms            | 3.2e-05 | 20      |
 | 1   | PERLANCAR::Permute::Named | 13ms   | 3.4ms             | 5.6e-05 | 20      |
 | 3   | Permute::Named::Iter      | 13.1ms | 3.21ms            | 3.6e-05 | 20      |
 | 0   | perl -e1 (baseline)       | 9.9ms  | 0ms               | 3.8e-05 | 20      |
 +-----+---------------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-PermuteNamedModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-PermuteNamedModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-PermuteNamedModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
