package Bencher::Scenario::GamesWordlists;

our $DATE = '2016-01-07'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup overhead of Games::Word::Wordlist::* modules',
    module_startup => 1,
    participants => [
        {module=>'Games::Word::Wordlist::Country'},
        {module=>'Games::Word::Wordlist::CountrySingleWord'},
        {module=>'Games::Word::Wordlist::Enable'},
        {module=>'Games::Word::Wordlist::KBBI'},
        {module=>'Games::Word::Wordlist::SGB'},
        {module=>'Games::Word::Phraselist::Proverb::KBBI'},
        {module=>'Games::Word::Phraselist::Proverb::TWW'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of Games::Word::Wordlist::* modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GamesWordlists - Benchmark startup overhead of Games::Word::Wordlist::* modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::GamesWordlists (from Perl distribution Bencher-Scenario-GamesWordlists), released on 2016-01-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m GamesWordlists

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Games::Word::Wordlist::Country> 0.02

L<Games::Word::Wordlist::CountrySingleWord> 0.02

L<Games::Word::Wordlist::Enable> 2010090401

L<Games::Word::Wordlist::KBBI> 0.01

L<Games::Word::Wordlist::SGB> 2010091501

L<Games::Word::Phraselist::Proverb::KBBI> 0.03

L<Games::Word::Phraselist::Proverb::TWW> 0.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * Games::Word::Wordlist::Country (perl_code)

L<Games::Word::Wordlist::Country>



=item * Games::Word::Wordlist::CountrySingleWord (perl_code)

L<Games::Word::Wordlist::CountrySingleWord>



=item * Games::Word::Wordlist::Enable (perl_code)

L<Games::Word::Wordlist::Enable>



=item * Games::Word::Wordlist::KBBI (perl_code)

L<Games::Word::Wordlist::KBBI>



=item * Games::Word::Wordlist::SGB (perl_code)

L<Games::Word::Wordlist::SGB>



=item * Games::Word::Phraselist::Proverb::KBBI (perl_code)

L<Games::Word::Phraselist::Proverb::KBBI>



=item * Games::Word::Phraselist::Proverb::TWW (perl_code)

L<Games::Word::Phraselist::Proverb::TWW>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+------------------------------------------+--------+-------------------+---------+---------+
 | seq | name                                     | time   | mod_overhead_time | errors  | samples |
 +-----+------------------------------------------+--------+-------------------+---------+---------+
 | 2   | Games::Word::Wordlist::CountrySingleWord | 35ms   | 30ms              | 0.00014 | 20      |
 | 5   | Games::Word::Wordlist::SGB               | 35.1ms | 30.3ms            | 0.00011 | 20      |
 | 4   | Games::Word::Wordlist::KBBI              | 35ms   | 30ms              | 0.00018 | 20      |
 | 6   | Games::Word::Phraselist::Proverb::KBBI   | 35ms   | 30ms              | 0.00016 | 21      |
 | 7   | Games::Word::Phraselist::Proverb::TWW    | 34.4ms | 29.6ms            | 4.8e-05 | 20      |
 | 1   | Games::Word::Wordlist::Country           | 34.3ms | 29.5ms            | 7.5e-05 | 22      |
 | 3   | Games::Word::Wordlist::Enable            | 33.8ms | 29ms              | 7.9e-05 | 20      |
 | 0   | perl -e1 (baseline)                      | 4.8ms  | 0ms               | 7.1e-05 | 20      |
 +-----+------------------------------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-GamesWordlists>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-GamesWordlists>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-GamesWordlists>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
