package Bencher::Scenario::Data::Sah::Normalize;

our $DATE = '2015-12-23'; # DATE
our $VERSION = '0.01'; # VERSION

# TODO: benchmark normalize_clset

our $scenario = {
    summary => 'Benchmark normalizing Sah schema',
    participants => [
        {
            fcall_template => 'Data::Sah::Normalize::normalize_schema(<schema>)'
        },
    ],
    datasets => [

        {
            name    => 'str',
            summary => '',
            args    => {
                schema => 'str',
            },
        },

        {
            name => 'str_wildcard',
            args => {
                schema => 'str*',
            },
        },

        {
            name => 'array1',
            args => {
                schema => ['str'],
            },
        },

        {
            name => 'array3',
            args => {
                schema => ['str', len=>1],
            },
        },

        {
            name => 'array5',
            args => {
                schema => ['str', min_len=>8, max_len=>16],
            },
        },

    ],
};

1;
# ABSTRACT: Benchmark normalizing Sah schema

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Data::Sah::Normalize

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::Data::Sah::Normalize (from Perl distribution Bencher-Scenario-DataSah), released on 2015-12-23.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BENCHMARKED MODULES

L<Data::Sah::Normalize>

=cut
