package Bencher::Scenario::ComparingArrays;

our $DATE = '2019-03-24'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

our $scenario = {
    summary => 'Modules that compare arrays',
    modules => {
        'Data::Cmp' => 0.002,
    },
    participants => [
        {
            module => 'Data::Cmp',
            fcall_template => 'Data::Cmp::cmp_data(<array1>, <array2>)',
            tags => ["int","str"],
        },
        {
            module => 'Array::Compare',
            code_template => 'Array::Compare->new()->compare(<array1>, <array2>)',
            tags => ["int","str"],
        },
        {
            module => 'Arrays::Same',
            fcall_template => 'Arrays::Same::arrays_same_i(<array1>, <array2>)',
            tags => ["int"],
        },
        {
            module => 'Arrays::Same',
            fcall_template => 'Arrays::Same::arrays_same_s(<array1>, <array2>)',
            tags => ["str"],
        },
        {
            name => 'loop',
            code_template => 'my $a1=<array1>; my $a2=<array2>; return 0 unless @$a1 == @$a2; for (0..$#{$a1}) { return 0 if $a1->[$_] != $a2->[$_] } 1',
            tags => ["int"],
        },
        {
            name => 'loop',
            code_template => 'my $a1=<array1>; my $a2=<array2>; return 0 unless @$a1 == @$a2; for (0..$#{$a1}) { return 0 if $a1->[$_] ne $a2->[$_] } 1',
            tags => ["str"],
        },
    ],

    datasets => [
        {name=>'empty'        , args=>{array1=>[], array2=>[]}},
        {name=>'10-int-same'  , args=>{array1=>[1..10], array2=>[1..10]}, include_participant_tags=>["int"]},
        {name=>'10-str-same'  , args=>{array1=>[("a")x 10], array2=>[("a")x 10]}, include_participant_tags=>["str"]},
        {name=>'100-int-same' , args=>{array1=>[1..100], array2=>[1..100]}, include_participant_tags=>["int"]},
        {name=>'100-str-same' , args=>{array1=>[("a")x 100], array2=>[("a")x 100]}, include_participant_tags=>["str"]},
        {name=>'1000-int-same', args=>{array1=>[1..1000], array2=>[1..1000]}, include_participant_tags=>["int"]},
        {name=>'1000-str-same', args=>{array1=>[("a")x 1000], array2=>[("a")x 1000]}, include_participant_tags=>["str"]},
    ],
};

1;
# ABSTRACT: Modules that compare arrays

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ComparingArrays - Modules that compare arrays

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ComparingArrays (from Perl distribution Bencher-Scenario-ComparingArrays), released on 2019-03-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ComparingArrays

To run module startup overhead benchmark:

 % bencher --module-startup -m ComparingArrays

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Compare> 3.0.2

L<Arrays::Same> 0.002

L<Data::Cmp> 0.006

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Cmp::cmp_data (perl_code) [int, str]

Function call template:

 Data::Cmp::cmp_data(<array1>, <array2>)



=item * Array::Compare (perl_code) [int, str]

Code template:

 Array::Compare->new()->compare(<array1>, <array2>)



=item * Arrays::Same::arrays_same_i (perl_code) [int]

Function call template:

 Arrays::Same::arrays_same_i(<array1>, <array2>)



=item * Arrays::Same::arrays_same_s (perl_code) [str]

Function call template:

 Arrays::Same::arrays_same_s(<array1>, <array2>)



=item * loop (perl_code) [int]

Code template:

 my $a1=<array1>; my $a2=<array2>; return 0 unless @$a1 == @$a2; for (0..$#{$a1}) { return 0 if $a1->[$_] != $a2->[$_] } 1



=item * loop (perl_code) [str]

Code template:

 my $a1=<array1>; my $a2=<array2>; return 0 unless @$a1 == @$a2; for (0..$#{$a1}) { return 0 if $a1->[$_] ne $a2->[$_] } 1



=back

=head1 BENCHMARK DATASETS

=over

=item * empty

=item * 10-int-same

=item * 10-str-same

=item * 100-int-same

=item * 100-str-same

=item * 1000-int-same

=item * 1000-str-same

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.26.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 18.3 >>, OS kernel: I<< Linux version 4.10.0-38-generic >>.

Benchmark with default options (C<< bencher -m ComparingArrays >>):

 #table1#
 +-----------------------------+---------------+----------+-----------+-----------+------------+---------+---------+
 | participant                 | dataset       | p_tags   | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+---------------+----------+-----------+-----------+------------+---------+---------+
 | Data::Cmp::cmp_data         | 1000-str-same | int, str |    1100   |  890      |     1      | 2.5e-06 |      20 |
 | Data::Cmp::cmp_data         | 1000-int-same | int, str |    1200   |  850      |     1      |   3e-06 |      22 |
 | Array::Compare              | 1000-int-same | int, str |    2000   |  500      |     2      | 5.5e-06 |      21 |
 | Array::Compare              | 1000-str-same | int, str |    2200   |  460      |     1.9    | 7.4e-07 |      30 |
 | loop                        | 1000-str-same | str      |    4770   |  210      |     4.25   | 1.6e-07 |      20 |
 | loop                        | 1000-int-same | int      |    7300   |  140      |     6.5    | 2.1e-07 |      20 |
 | Arrays::Same::arrays_same_s | 1000-str-same | str      |    7819.1 |  127.89   |     6.9661 | 1.5e-10 |      20 |
 | Data::Cmp::cmp_data         | 100-str-same  | int, str |   10900   |   91.9    |     9.69   | 2.4e-08 |      24 |
 | Data::Cmp::cmp_data         | 100-int-same  | int, str |   11000   |   87      |    10      | 2.1e-07 |      20 |
 | Array::Compare              | 100-int-same  | int, str |   15000   |   68      |    13      | 1.1e-07 |      20 |
 | Array::Compare              | 100-str-same  | int, str |   16000   |   62      |    14      | 2.4e-07 |      20 |
 | Arrays::Same::arrays_same_i | 1000-int-same | int      |   19000   |   52.5    |    17      | 2.5e-08 |      22 |
 | Array::Compare              | 10-int-same   | int, str |   43000   |   23      |    38      | 2.7e-08 |      20 |
 | Array::Compare              | 10-str-same   | int, str |   45000   |   22      |    40      | 2.7e-08 |      20 |
 | loop                        | 100-str-same  | str      |   47900   |   20.9    |    42.7    | 6.7e-09 |      20 |
 | Array::Compare              | empty         | int, str |   55000   |   18      |    49      |   8e-08 |      20 |
 | loop                        | 100-int-same  | int      |   73000   |   13.7    |    65.1    |   6e-09 |      25 |
 | Arrays::Same::arrays_same_s | 100-str-same  | str      |   79000   |   13      |    70      | 8.3e-08 |      27 |
 | Data::Cmp::cmp_data         | 10-str-same   | int, str |   88000   |   11      |    78      | 1.3e-08 |      20 |
 | Data::Cmp::cmp_data         | 10-int-same   | int, str |   89940   |   11.12   |    80.13   | 2.3e-10 |      23 |
 | Arrays::Same::arrays_same_i | 100-int-same  | int      |  180000   |    5.4    |   160      |   2e-08 |      21 |
 | loop                        | 10-str-same   | str      |  377320   |    2.6503 |   336.16   | 1.1e-11 |      20 |
 | Data::Cmp::cmp_data         | empty         | int, str |  390000   |    2.6    |   350      | 3.3e-09 |      20 |
 | loop                        | 10-int-same   | int      |  527000   |    1.9    |   469      | 8.3e-10 |      20 |
 | Arrays::Same::arrays_same_s | 10-str-same   | str      |  649000   |    1.54   |   578      | 2.3e-10 |      20 |
 | Arrays::Same::arrays_same_i | 10-int-same   | int      | 1200000   |    0.82   |  1100      | 1.7e-09 |      20 |
 | loop                        | empty         | str      | 2100000   |    0.47   |  1900      | 2.5e-09 |      23 |
 | loop                        | empty         | int      | 2260000   |    0.442  |  2020      | 2.1e-10 |      20 |
 | Arrays::Same::arrays_same_s | empty         | str      | 4800000   |    0.21   |  4200      | 4.2e-10 |      20 |
 | Arrays::Same::arrays_same_i | empty         | int      | 4900000   |    0.21   |  4300      | 4.2e-10 |      20 |
 +-----------------------------+---------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ComparingArrays --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Array::Compare      |      53.5 |                   48.8 |        1   | 3.2e-05 |      20 |
 | Arrays::Same        |       8.9 |                    4.2 |        6   | 3.3e-05 |      20 |
 | Data::Cmp           |       8.5 |                    3.8 |        6.3 | 2.4e-05 |      20 |
 | perl -e1 (baseline) |       4.7 |                    0   |       11   | 1.8e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ComparingArrays>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ComparingArrays>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ComparingArrays>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
