package Bencher::Scenario::AcmePERLANCARTestPerformance;

our $DATE = '2016-03-17'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Acme::PERLANCAR::Test::Performance',
    participants => [
        {
            fcall_template => 'Acme::PERLANCAR::Test::Performance::primes(<num>)', result_is_list=>1,
        },
    ],
    datasets => [
        {name=>'100', args=>{num=>100}},
    ],
};

1;
# ABSTRACT: Benchmark Acme::PERLANCAR::Test::Performance

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::AcmePERLANCARTestPerformance - Benchmark Acme::PERLANCAR::Test::Performance

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::AcmePERLANCARTestPerformance (from Perl distribution Bencher-Scenario-AcmePERLANCARTestPerformance), released on 2016-03-17.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m AcmePERLANCARTestPerformance

To run module startup overhead benchmark:

 % bencher --module-startup -m AcmePERLANCARTestPerformance

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Acme::PERLANCAR::Test::Performance> 0.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * Acme::PERLANCAR::Test::Performance::primes (perl_code)

Function call template:

 Acme::PERLANCAR::Test::Performance::primes(<num>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 100

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m AcmePERLANCARTestPerformance --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.01 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.02 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.03 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.04 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.05 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.06 --multimodver Acme::PERLANCAR::Test::Performance >>:

 +--------+-----------+-----------+------------+---------+---------+
 | modver | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +--------+-----------+-----------+------------+---------+---------+
 | 0.01   | 518       | 1.93      | 1          | 6.2e-07 | 21      |
 | 0.02   | 1.94e+03  | 0.516     | 3.74       | 5.2e-08 | 21      |
 | 0.03   | 2.7e+03   | 0.38      | 5.1        | 8.8e-07 | 21      |
 | 0.05   | 5.14e+04  | 0.0194    | 99.2       | 5.4e-09 | 30      |
 | 0.04   | 57455.2   | 0.0174049 | 110.83     | 1.2e-11 | 20      |
 | 0.06   | 59635.5   | 0.0167685 | 115.036    | 0       | 20      |
 +--------+-----------+-----------+------------+---------+---------+


Benchmark with C<< bencher -m AcmePERLANCARTestPerformance --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.01 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.02 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.03 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.04 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.05 --include-path /home/s1/repos/perl-Acme-PERLANCAR-Test-Performance/archive/0.06 --module-startup --multimodver Acme::PERLANCAR::Test::Performance >>:

 +------------------------------------+--------+-----------+------------------------+------------+---------+---------+
 | participant                        | modver | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+--------+-----------+------------------------+------------+---------+---------+
 | Acme::PERLANCAR::Test::Performance | 0.02   | 6         | 4.4                    | 1          | 6.4e-05 | 21      |
 | Acme::PERLANCAR::Test::Performance | 0.04   | 5         | 3.4                    | 1.1        | 4.3e-05 | 20      |
 | Acme::PERLANCAR::Test::Performance | 0.06   | 4.9       | 3.3                    | 1.1        | 1.6e-05 | 20      |
 | Acme::PERLANCAR::Test::Performance | 0.01   | 4.8       | 3.2                    | 1.2        | 2.6e-05 | 20      |
 | Acme::PERLANCAR::Test::Performance | 0.03   | 4.7       | 3.1                    | 1.2        | 2.2e-05 | 20      |
 | Acme::PERLANCAR::Test::Performance | 0.05   | 4.7       | 3.1                    | 1.2        | 8.7e-06 | 20      |
 | perl -e1 (baseline)                |        | 1.6       | 0                      | 3.5        | 8.7e-06 | 20      |
 +------------------------------------+--------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-AcmePERLANCARTestPerformance>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-AcmePERLANCARTestPerformance>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-AcmePERLANCARTestPerformance>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
