package App::lcpan::Call;

our $DATE = '2015-05-15'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our %SPEC;

require Exporter;
our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(call_lcpan_script);

$SPEC{call_lcpan_script} = {
    v => 1.1,
    summary => '"Call" lcpan script',
    args => {
        # XXX max_index_age (default 5 days)
        argv => {
            schema => ['array*', of=>'str*'],
            default => [],
        },
    },
};
sub call_lcpan_script {
    require Perinci::CmdLine::Call;

    my %args = @_;

    state $checked;
    unless ($checked) {
        require File::Which;
        File::Which::which("lcpan")
            or die "lcpan is not available, please install it first\n";
        my $res = Perinci::CmdLine::Call::call_cli_script(
            script => 'lcpan',
            argv   => ['stats'],
        );
        die "Can't 'lcpan stats': $res->[0] - $res->[1]\n"
            unless $res->[0] == 200;
        my $stats = $res->[2];
        if ((time - $stats->{raw_last_index_time}) > 5*86400) {
            die "lcpan index is over 5 days old, please refresh it first ".
                "with 'lcpan update'\n";
        }
    }

    my $res = Perinci::CmdLine::Call::call_cli_script(
        script => 'lcpan',
        argv   => $args{'argv'},
    );
    die "Can't 'lcpan ".join(" ", @{ $args{argv} || [] })."': $res->[0] - $res->[1]\n"
        unless $res->[0] == 200;
    $res->[2];
}

1;
# ABSTRACT: "Call" lcpan script

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Call - "Call" lcpan script

=head1 VERSION

This document describes version 0.01 of App::lcpan::Call (from Perl distribution App-lcpan-Call), released on 2015-05-15.

=head1 FUNCTIONS


=head2 call_lcpan_script(%args) -> [status, msg, result, meta]

"Call" lcpan script.

Arguments ('*' denotes required arguments):

=over 4

=item * B<argv> => I<array[str]> (default: [])

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan-Call>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan-Call>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan-Call>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
