package App::IODUtils;

our $VERSION = '0.03'; # VERSION
our $DATE = '2014-08-30'; # DATE

use 5.010001;

our %common_args = (
    iod => {
        summary => 'IOD file',
        schema  => ['str*'],
        req     => 1,
        pos     => 0,
        cmdline_src => 'stdin_or_files',
    },
    enable_expr => {
        schema  => 'bool',
        default => 0,
        cmdline_aliases => {e=>{}},
    },
);

1;
# ABSTRACT: IOD utilities

__END__

=pod

=encoding UTF-8

=head1 NAME

App::IODUtils - IOD utilities

=head1 VERSION

This document describes version 0.03 of App::IODUtils (from Perl distribution App-IODUtils), released on 2014-08-30.

=head1 SYNOPSIS

This distribution provides the following command-line utilities:

 dump-iod
 get-iod-key
 get-iod-section
 list-iod-sections

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-IODUtils>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-IODUtils>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-IODUtils>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
