package Acme::CPANLists::PERLANCAR::Task::WorkingWithTree;

our $DATE = '2016-07-25'; # DATE
our $VERSION = '0.17'; # VERSION

my $text = <<'_';
**Basics**

Perl classes to represent tree (node) structure: `Tree::Object` and
`Tree::ObjectXS` (comes with several varieties). They provide methods like
walking a tree, checking whether a node is the first child, getting sibling
nodes, and so on.

Perl modules to manipulate tree: `Data::Tree`, `Tree::Simple`.

Memory-efficient tree nodes in Perl: `Tree::Node`.


**Creating**

`Tree::FromStruct`, `Tree::FromText`, `Tree::FromTextLines`,
`Tree::Create::Callback`, `Tree::Create::Callback::ChildrenPerLevel`,
`Tree::Create::Size`, `Tree::FromFS`.

`Data::Random::Tree`.


**Visualizing as text**

`Tree::ToText`, `Tree::ToTextLines`.


**Visualizing as graphic**

TODO


**Other modules**

`Tree::ToFS`.

Special kinds of trees: TODO.


**Roles**

`Role::TinyCommons::Tree`.

_

our @Module_Lists = (
    {
        summary => 'Working with tree data structure in Perl',
        description => $text,
        tags => ['task'],
        entries => [
            map { +{module=>$_} } $text =~ /`(\w+(?:::\w+)+)`/g
        ],
    },
);

1;
# ABSTRACT: Working with tree data structure in Perl

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::PERLANCAR::Task::WorkingWithTree - Working with tree data structure in Perl

=head1 VERSION

This document describes version 0.17 of Acme::CPANLists::PERLANCAR::Task::WorkingWithTree (from Perl distribution Acme-CPANLists-PERLANCAR), released on 2016-07-25.

=head1 MODULE LISTS

=head2 Working with tree data structure in Perl

B<Basics>

Perl classes to represent tree (node) structure: C<Tree::Object> and
C<Tree::ObjectXS> (comes with several varieties). They provide methods like
walking a tree, checking whether a node is the first child, getting sibling
nodes, and so on.

Perl modules to manipulate tree: C<Data::Tree>, C<Tree::Simple>.

Memory-efficient tree nodes in Perl: C<Tree::Node>.

B<Creating>

C<Tree::FromStruct>, C<Tree::FromText>, C<Tree::FromTextLines>,
C<Tree::Create::Callback>, C<Tree::Create::Callback::ChildrenPerLevel>,
C<Tree::Create::Size>, C<Tree::FromFS>.

C<Data::Random::Tree>.

B<Visualizing as text>

C<Tree::ToText>, C<Tree::ToTextLines>.

B<Visualizing as graphic>

TODO

B<Other modules>

C<Tree::ToFS>.

Special kinds of trees: TODO.

B<Roles>

C<Role::TinyCommons::Tree>.


=over

=item * L<Tree::Object>

=item * L<Tree::ObjectXS>

=item * L<Data::Tree>

=item * L<Tree::Simple>

=item * L<Tree::Node>

=item * L<Tree::FromStruct>

=item * L<Tree::FromText>

=item * L<Tree::FromTextLines>

=item * L<Tree::Create::Callback>

=item * L<Tree::Create::Callback::ChildrenPerLevel>

=item * L<Tree::Create::Size>

=item * L<Tree::FromFS>

=item * L<Data::Random::Tree>

=item * L<Tree::ToText>

=item * L<Tree::ToTextLines>

=item * L<Tree::ToFS>

=item * L<Role::TinyCommons::Tree>

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANLists> - about the Acme::CPANLists namespace

L<acme-cpanlists> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
