package Acme::CPANLists::PERLANCAR;

our $DATE = '2015-06-30'; # DATE
our $VERSION = '0.03'; # VERSION

our @Module_Lists = (
    {
        summary => 'Random module reviews',
        entries => [
            {
                module => 'App::cpanoutdated::coro',
                description => <<'_',

66% faster than pm:App::cpanoutdated when run against a normal CPAN mirror (no
speed improvement if you run it against a local CPAN mirror like MiniCPAN
though). Wouldn't mind faster version of stuffs :-)

_
                rating => 5,
            },
        ],
    },

    {
        summary => 'One-letter CPAN modules',
        description => <<'_',

Just a list of one-letter modules on CPAN.

_
        entries => [
            {module=>'B'},
            {module=>'L'},
            {module=>'P'},
            {module=>'U'},
            {module=>'V'},
        ],
    },
);

our @Author_Lists = (
    {
        summary => 'Test list',
        entries => [
            {author=>'BARBIE'},
            {author=>'NEILB'},
            {author=>'RJBS'},
        ],
    },

    {
        summary => 'Another test list',
        entries => [
            {author=>'BARBIE'},
            {author=>'MANWAR'},
            {author=>'SKIM'},
            {author=>'NEILB'},
            {author=>'KENTNL'},
            {author=>'ETHER'},
            {author=>'CSSON'},
            {author=>'INGY'},
            {author=>'IVANWILLS'},
            {author=>'RENEEB'},
        ],
    },
);

1;
# ABSTRACT: PERLANCAR's CPAN lists

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::PERLANCAR - PERLANCAR's CPAN lists

=head1 VERSION

This document describes version 0.03 of Acme::CPANLists::PERLANCAR (from Perl distribution Acme-CPANLists-PERLANCAR), released on 2015-06-30.

=head1 DESCRIPTION

This distribution is an experiment for providing data that can be used by
L<https://cpanlists.org> (when I finally get around to finishing the project),
L<lcpan> (when I implement indexing of module source codes), as well as
L<http://cpanratings.perl.org> (as I'm currently having trouble logging in to
the site).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR LISTS

=head2 Test list

=over

=item * L<BARBIE|https://metacpan.org/author/BARBIE>

=item * L<NEILB|https://metacpan.org/author/NEILB>

=item * L<RJBS|https://metacpan.org/author/RJBS>

=back

=head2 Another test list

=over

=item * L<BARBIE|https://metacpan.org/author/BARBIE>

=item * L<MANWAR|https://metacpan.org/author/MANWAR>

=item * L<SKIM|https://metacpan.org/author/SKIM>

=item * L<NEILB|https://metacpan.org/author/NEILB>

=item * L<KENTNL|https://metacpan.org/author/KENTNL>

=item * L<ETHER|https://metacpan.org/author/ETHER>

=item * L<CSSON|https://metacpan.org/author/CSSON>

=item * L<INGY|https://metacpan.org/author/INGY>

=item * L<IVANWILLS|https://metacpan.org/author/IVANWILLS>

=item * L<RENEEB|https://metacpan.org/author/RENEEB>

=back

=head1 MODULE LISTS

=head2 Random module reviews

=over

=item * L<App::cpanoutdated::coro>

66% faster than pm:App::cpanoutdated when run against a normal CPAN mirror (no
speed improvement if you run it against a local CPAN mirror like MiniCPAN
though). Wouldn't mind faster version of stuffs :-)


=back

=head2 One-letter CPAN modules

Just a list of one-letter modules on CPAN.


=over

=item * L<B>

=item * L<L>

=item * L<P>

=item * L<U>

=item * L<V>

=back

=cut
