package Acme::CPANLists::Import::NEILB::LUHN;

our $DATE = '2016-02-21'; # DATE
our $VERSION = '0.01'; # VERSION

our @Module_Lists = ({entries=>[{module=>"Algorithm::CheckDigits"},{module=>"Business::BankCard"},{module=>"Business::CardInfo"},{module=>"Regexp::Common"},{module=>"Regexp::Common::_support"}],summary=>"Checking credit card numbers (LUHN check)"});

1;
# ABSTRACT: Checking credit card numbers (LUHN check)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::Import::NEILB::LUHN - Checking credit card numbers (LUHN check)

=head1 VERSION

This document describes version 0.01 of Acme::CPANLists::Import::NEILB::LUHN (from Perl distribution Acme-CPANLists-Import-NEILB), released on 2016-02-21.

=head1 DESCRIPTION

This module is generated by extracting module names mentioned in the article L<http://neilb.org/reviews/luhn.html>. For the full article, visit the URL.

=head1 MODULE LISTS

=head2 Checking credit card numbers (LUHN check)

=over

=item * L<Algorithm::CheckDigits>

=item * L<Business::BankCard>

=item * L<Business::CardInfo>

=item * L<Regexp::Common>

=item * L<Regexp::Common::_support>

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-Import-NEILB>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-Import-NEILB>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-Import-NEILB>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANLists> - about the Acme::CPANLists namespace

L<acme-cpanlists> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
