import os, os.path, re, sys


def _makePatch(code):
    return '/* (POSTPROCESSING-PATCH : BEGIN) */\n%s\n/* (POSTPROCESSING-PATCH : END) */' % code


def patchDirectorMethodMemoryLeak(code):
    # If a Swig::DirectorMethodException is raised in a director method, SWIG
    # fails to generate decref calls for the Python objects it created to pass
    # as arguments to the Python subclass.
    # This function finds all such instances in the wrapper code generated by
    # SWIG, determines how many Python arguments SWIG allocated, and generates
    # a Py_XDECREF call for each.
    reDirectorMethodHeader = re.compile(
        r'(?P<class_name>SwigDirector_\w+)\s*::\s*(?P<method_name>\w+).+?\{\s*$'
        , re.DOTALL + re.MULTILINE
      )

    patThrowSDME = r'throw\s+Swig::DirectorMethodException'
    #reThrowSDME = re.compile(patThrowSDME, re.DOTALL + re.MULTILINE)

    reDirectorMethodStart = re.compile(
        r'(?P<intermediate_code>.*?)(?P<throw_sdme>' + patThrowSDME + r')'
        , re.DOTALL + re.MULTILINE
      )

    rePyObjectDec = re.compile(
        r'(PyObject\s*\*\s*(?P<py_var_name>obj\d+)\s*=.*?$)'
        , re.DOTALL + re.MULTILINE
      )

    fixes = []
    for m in reDirectorMethodHeader.finditer(code):
        headerCode = m.group()
        className = m.group('class_name')
        methodName = m.group('method_name')
        if className == methodName:
           print 'Skipping %s::%s' % (className, methodName)
           continue # Ignore constructors.
        print 'Patching %s::%s' % (className, methodName)

        mInter = reDirectorMethodStart.search(code[m.end():])
        fixedSlice = slice(m.start(), m.end() + mInter.end('intermediate_code'))
        bodyStartCode = mInter.group('intermediate_code')

        pyVarNames = [
           mPyVar.group('py_var_name')
           for mPyVar in rePyObjectDec.finditer(bodyStartCode)
         ]

        decrefCode = '\n'.join( ['Py_XDECREF(%s);' % varName for varName in pyVarNames] )
        decrefCode = _makePatch(decrefCode)
        bodyStartCodeFixed = '%s\n%s\n' % (bodyStartCode.rstrip(), decrefCode)

        fixedCodeSnippet = '%s %s' % (headerCode.rstrip(), bodyStartCodeFixed)

        fixes.append( (fixedSlice, fixedCodeSnippet) )

    codeFixed = code
    for fixedSlice, fixedCodeSnippet in fixes:
        codeFixed = codeFixed.replace(code[fixedSlice], fixedCodeSnippet)

    return codeFixed, len(fixes)


def main():
    print
    print '=' * 79
    print 'swig_postprocess.py POST-PROCESSING GENERATED FILE TO FIX SWIG BUGS'
    print '=' * 79
    print

    codeFN = '_clucene_wrap.cpp'
    code = file(codeFN, 'rb').read().replace('\r\n', '\n')

    def phaseEnter(desc):
        if not hasattr(phaseEnter, 'n'):
            phaseEnter.n = 0
        phaseEnter.n += 1
        print
        print ':' * 70
        print 'PHASE %d:  "%s"' % (phaseEnter.n, desc)
        print ':' * 70
        print


    def phaseVerify(desc, nPatchesExpected, nPatchesEncountered):
        if nPatchesEncountered != nPatchesExpected:
            print ('Exiting with error:\n  Expected %d patches by %s; found %d'
                % (nPatchesExpected, desc, nPatches)
              )
            sys.exit(1)


    phaseName = 'patchDirectorMethodMemoryLeak'
    phaseEnter(phaseName)
    code, nPatches = patchDirectorMethodMemoryLeak(code)
    phaseVerify(phaseName, 3, nPatches)


    file(codeFN, 'wb').write(code)


if __name__ == '__main__':
    main()