package Net::DNS::RR::KEY;

# $Id: KEY.pm 865 2011-01-05 22:15:24Z willem $

use strict;
use vars qw(@ISA $VERSION);
use bytes;
use Net::DNS;
use MIME::Base64;
use Carp;

@ISA = qw(Net::DNS::RR::DNSKEY);
$VERSION = do { my @r=(q$Revision: 865 $=~/\d+/g); sprintf "%d."."%03d"x$#r,@r };

sub new {
	return Net::DNS::RR::DNSKEY::new(@_);
}

sub new_from_string {
	return Net::DNS::RR::DNSKEY::new_from_string(@_);
}




1;


=head1 NAME

Net::DNS::RR::KEY - DNS KEY resource record

=head1 SYNOPSIS

C<use Net::DNS::RR;>

=head1 DESCRIPTION

Class for DNS Address (KEY) resource records.

=head1 METHODS

This class inherits most of its methods from DNSKEY. See DNSKEY for a
complete list of available methods.

=head2 flags

    print "flags" = ", $rr->flags, "\n";

Returns the RR's flags in decimal representation


=head2 protocol

    print "protocol" = ", $rr->protocol, "\n";

Returns the RR's protocol field in decimal representation

=head2 algorithm

    print "algorithm" = ", $rr->algorithm, "\n";

Returns the RR's algorithm field in decimal representation

    1 = MD5 RSA
    2 = DH
    3 = DSA                
    4 = Elliptic curve
    5 = SHA1 RSA

Note that only algorithm 1 and 3 are supported by the methods provided
through Net::DNS::RR::SIG.pm.

=head2 key

    print "key" = ", $rr->key, "\n";

Returns the key in base64 representation


=head2 keybin

    $keybin =  $rr->keybin;

Returns the key binary material


=head2 keytag

    print "keytag" = ", $rr->keytag, "\n";

Returns the key tag of the key. (RFC2535 4.1.6)

=head2 privatekeyname

    $privatekeyname=$rr->privatekeyname

Returns the name of the privatekey as it would be generated by
the BIND dnssec-keygen program. The format of that name being
K\<fqdn\>+\<algorithm\>+\<keyid\>.private



    

=head1 COPYRIGHT

Copyright (c) 2001-2005  RIPE NCC.  Author Olaf M. Kolkman <olaf@net-dns.org>

All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the author not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.


THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


Based on, and contains, code by Copyright (c) 1997 Michael Fuhr.


=head1 SEE ALSO

L<http://www.net-dns.org/> 

L<perl(1)>, L<Net::DNS>, L<Net::DNS::Resolver>, L<Net::DNS::Packet>,
L<Net::DNS::Header>, L<Net::DNS::Question>, L<Net::DNS::RR>,
RFC 2931.

=cut
