use 5.008;
use strict;

package MY;
use ExtUtils::MakeMaker;
use vars qw(@ISA);
@ISA = qw(ExtUtils::MakeMaker);
require 'lib/Unicode/LineBreak/Version.pm';

my $unicode_version = Unicode::LineBreak::DEFAULT_UNICODE_VERSION();
my $enable_libthai;
my $csubdir = 'linebreak';

sub postamble {
    return <<EOF;
\$(MYEXTLIB): $csubdir/Makefile
	cd $csubdir && \$(MAKE)
$csubdir/Makefile: $csubdir/configure
	cd $csubdir && ./configure --disable-shared --enable-static \\
	--with-unicode-version=$unicode_version \\
	--enable-libthai=$enable_libthai \\
        CFLAGS='\$(CCFLAGS) \$(OPTIMIZE) \$(CCCDLFLAGS)'
$csubdir/configure: $csubdir/configure.in
	cd $csubdir && ./autogen.sh && \\
	\$(PERL) -i -pe '/\\bVERSION\\b/ and \$\$_="/* \$\$_ */"' config.h.in
EOF
}

my @opts = ();
my $libthai = `pkg-config --modversion libthai`;
chomp $libthai;
if ($libthai and ($ARGV[0] || '') ne 'nolibthai') {
    print "Use libthai $libthai\n";
    $enable_libthai = 'yes';
    push @opts, ('LIBS' => `pkg-config --libs libthai`);
} else {
    $enable_libthai = 'no';
}
push @opts, ('INC' => "-I./$csubdir");

WriteMakefile(
	'NAME'		=> 'Unicode::LineBreak',
	'ABSTRACT_FROM'	=> 'lib/Unicode/LineBreak.pod',
	'VERSION_FROM'	=> 'lib/Unicode/LineBreak/Version.pm',
	'AUTHOR'	=> q{Hatuka*nezumi - IKEDA Soji <hatuka@nezumi.nu>},
	'LICENSE'	=> 'perl',
	'PREREQ_PM'	=> {
	    'Encode'		=> 1.98,
	    'MIME::Charset'	=> '1.006.2',
	    'Test::More'	=> '0.45',
	},
	'MYEXTLIB' => "$csubdir/.libs/libinebreak\$(LIB_EXT)",
	# Un-comment this if you add C files to link with later:
	# 'OBJECT'	=> '$(O_FILES)', # link all the C files too
	@opts,
);
