package Data::TableReader::Decoder;
$Data::TableReader::Decoder::VERSION = '0.001';
use Moo 2;

# ABSTRACT: Base class for table decoders


has file_name   => ( is => 'ro', required => 1 );
has file_handle => ( is => 'ro', required => 1 );
has log         => ( is => 'ro', required => 1 );
has iterator    => ( is => 'lazy' );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::TableReader::Decoder - Base class for table decoders

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This is an abstract base class describing the API for decoders.

A decoder's job is to iterate table rows of a file containing tabular data.
If a file provides multiple tables of data (such as worksheets, or <TABLE>
tags) then the decode should also support the "next_dataset" method.

=head1 ATTRIBUTES

=head2 filename

Set by TableReader.  Useful for logging.

=head2 file_handle

Set by TableReader.  This is what the iterator should parse.

=head2 log

Set by TableReader.  Unlike the attribute of the same name on
TableReader, this is always a coderef, to be called as:

  $log->($level, $message);

=head2 iterator

This lazy-builds the iterator from L</_build_iterator>

=head1 METHODS

=head2 _build_iterator

This must be implemented by the subclass, to return an instance of
L<Data::TableReader::Iterator>.  The iterator should return an arrayref
each time it is called.  The iterator may also accept a single argument of
a list of columns to retrieve, rather than retrieving the full row.

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
