package DateTime::Age;

=head1 NAME
 
DateTime::Age - Calculates the age from specific date.
=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.100000';

use utf8;
use strict;
use warnings;
use Time::Local;
use vars qw($VERSION @EXPORT_OK);

require Exporter;
*import    = \&Exporter::import;
@EXPORT_OK = qw(to_age);
our %EXPORT_TAGS = ( 'all' => [@EXPORT_OK] );

=head1 SUBROUTINES/METHODS

=head2 to_age

=cut

sub to_age {
    my ( $birth_year, $birth_month, $birth_day ) = @_;
    $birth_month = $birth_month - 1;    # Assuming $birth_month is 0..11
    my ( $day, $month, $year ) = (localtime)[ 3 .. 5 ];
    $year += 1900;
    my $age = $year - $birth_year;
    $age-- unless sprintf( "%02d%02d", $month, $day ) >= sprintf( "%02d%02d", $birth_month, $birth_day );
    return $age;
}

1;  # End of DateTime::Age

__END__
 
 
=head1 SYNOPSIS
 
  use DateTime::Age qw/to_age/;
  
  my $age = to_age(1983, 6, 2);
 
  #the content of $age depends on to age params and current year.
 
=head1 DESCRIPTION
 
Calculates the age from specific date.
 
=head1 AUTHOR

Mario Zieschang, C<< <mziescha at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-datetime-age at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=DateTime-Age>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc DateTime::Age


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=DateTime-Age>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/DateTime-Age>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/DateTime-Age>

=item * Search CPAN

L<http://search.cpan.org/dist/DateTime-Age/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2015 Maio Zieschang.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=head1 SEE ALSO
 
L<DateTime::Span>, L<Date::Range::Birth>, L<DateTime::Span::Birthdate>
 
=cut
