use XML::XSLT::Wrapper;

my $xml_file = 'example.xml';
my $xsl_file = 'example.xsl';
my $out_file = 'out.xml';

my $xslt = XML::XSLT::Wrapper->new(
    ProcessorList => ['xt'],
    JavaCommand => '-Dcom.jclark.xsl.sax.parser=com.jclark.xml.sax.CommentDriver com.jclark.xsl.sax.Driver',
    Debug => 1,
);

my $result = $xslt->transform(
		    xml => $xml_file,
		    xsl => $xsl_file,
		    XSLParams => { 'COMEIN' => 'knock knock',
				    'GOOUT' => 'bang bang',
				},
		);


print "\n1: ";
if (!(defined($result))) {
    print "Transform failed: \$result undefined\n";
} elsif ($result eq '') {
    print "Wrote outfile\n";
} else {
    print "Result string received:\n", $result;
}

$result = $xslt->transform(
		    xml => $xml_file,
		    xsl => $xsl_file,
		    OutFile => $out_file,
		    XSLParams => { 'COMEIN' => 'knock knock',
				    'GOOUT' => 'bang bang',
				},
		);


print "\n2: ";
if (!(defined($result))) {
    print "Transform failed: \$result undefined\n";
} elsif ($result eq '') {
    print "Wrote outfile\n";
} else {
    print "Result string received:\n", $result;
}

