# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)
use strict;

use vars qw($Total_tests);

my $loaded;
my $test_num = 1;
BEGIN { $| = 1; $^W = 1; }
END {print "not ok $test_num\n" unless $loaded;}
print "1..$Total_tests\n";
use Class::Fields::Fuxor;
$loaded = 1;
print "ok $test_num - Compile\n";
$test_num++;
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):
sub ok {
    my($test, $name) = @_;
    print "not " unless $test;
    print "ok $test_num";
    print " - $name" if defined $name;
    print "\n";
    $test_num++;
}

sub eqarray  {
    my($a1, $a2) = @_;
    return 0 unless @$a1 == @$a2;
    my $ok = 1;
    for (0..$#{$a1}) { 
        unless($a1->[$_] eq $a2->[$_]) {
        $ok = 0;
        last;
        }
    }
    return $ok;
}

# Change this to your # of ok() calls + 1
BEGIN { $Total_tests = 10 }

package Foo;

package Bar;

use Class::Fields::Attribs;
use Class::Fields::Fuxor;

BEGIN {
    add_fields('Yar', PUBLIC,       qw(Pub Pants));
    add_fields('Yar', PRIVATE,      qw(_Priv _Pantaloons));
    add_fields('Yar', PROTECTED,    qw(_Prot Armoured));
}

::ok( get_fields('Yar') == \%Yar::FIELDS,           'get_fields()'          );
::ok( get_attr('Yar') == $fields::attr{Yar},        'get_attr()'            );
::ok( ::eqarray([sort keys %{get_fields('Yar')}], 
                [sort qw(Pub Pants _Priv _Pantaloons _Prot Armoured)] 
               ),
      'add_fields()'
    );

::ok( has_fields('Yar'),                            'has_fields(), true'    );
::ok( !has_fields('I::have::no::fields'),           'has_fields(), false'   );
::ok( keys %{get_fields('I::have::no::fields')} == 0,
                                                  'get_fields(), no fields' );
::ok( has_fields('I::have::no::fields'),            
                                              'has_fields(), autogenerated' );

my Yar $yar = [];

eval {
    $yar->{Pub}     = "Foo";
    $yar->{_Priv}   = "Bar";
    $yar->{Armoured} = "Hey";
};
::ok($@ eq '' or $@ !~ /no such field/i);


# Test out all the functions as class methods.
package As::Meths;

use base qw( Class::Fields::Fuxor );
use Class::Fields::Attribs;
::ok( !As::Meths->has_fields,                'has_fields() false as method' );
As::Meths->add_fields( PUBLIC, qw(this that) );
    




