/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesLegend
extends CommandMultilines2<UmlDiagram> {
    public CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("legend"), new RegexLeaf("ALIGN", "(?:[%s]+(left|right|center))?"), new RegexLeaf("$"));
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?legend$";
    }

    @Override
    public CommandExecutionResult executeNow(UmlDiagram umlDiagram, List<String> list) {
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        String string = regexResult.get("ALIGN", 0);
        Display display = Display.create(list.subList(1, list.size() - 1)).removeEmptyColumns();
        if (display.size() > 0) {
            HorizontalAlignment horizontalAlignment = HorizontalAlignment.fromString(string);
            if (horizontalAlignment == null) {
                horizontalAlignment = HorizontalAlignment.CENTER;
            }
            umlDiagram.setLegend(StringUtils.manageEmbededDiagrams(display), horizontalAlignment);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

