##-*- Mode: CPerl -*-

## File: DDC::Query::Filter.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + extendable full-text index using mysql: abstract queries: parser (high-level)
##======================================================================

package DDC::Query::Filter;
use DDC::Utils qw(:escape);
use strict;

##======================================================================
## Globals etc.
our @ISA = qw();

##======================================================================
## $qf = $CLASS_OR_OBJ->new(%args)
##  + %$qf, %args =
##    (
##     class => $class,     ##-- subclass
##     name  =>$name,  ##-- filter name (with leading '#')
##     args  =>\@args, ##-- filter args
##    )
sub new {
  my ($that,%args) = @_;
  my $class = $args{class};
  my ($new);
  if ($class && defined($new=UNIVERSAL::can((__PACKAGE__ . "::$class"), 'new'))) {
    delete($args{class});
    return $new->((__PACKAGE__ . "::$class"),%args) if ($new ne __PACKAGE__->can('new'));
  }
  return bless(\%args,
	       ($class ? (__PACKAGE__ . "::$class") : (ref($that)||$that))
	      );
}

## $str = $qf->toString()
##  + stringification operator
sub toString {
  my $qf = shift;
  my $s = (uc($qf->{name})
	   .'['
	   .join(',',
		 map {defined($_) ? escapeq($_) : ''}
		 @{$qf->{args}}
		)
	   .']');
  $s =~ s/\[\]$//;
  return $s;
}

##======================================================================
package DDC::Query::Filter::Sort;
our @ISA = qw(DDC::Query::Filter);

##======================================================================
package DDC::Query::Filter::Flag;
our @ISA = qw(DDC::Query::Filter);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#FLAG',arg=>undef,@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return (
	  ($qf->{negated} ? '!' : '')
	  .uc($qf->{name})
	  .(defined($qf->{arg}) ? " $qf->{arg}" : '')
	 );
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Subcorpora;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>':',args=>[],@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return ":".join(',',map {escapeq($_)} @{$qf->{args}});
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Context;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#CNTXT',arg=>0,@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Within;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#WITHIN',arg=>'s',@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::Filenames;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#FILENAMES',arg=>undef,negated=>undef,@_);
}

##----------------------------------------------------------------------
package DDC::Query::Filter::DebugRank;
our @ISA = qw(DDC::Query::Filter::Flag);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#DEBUG_RANK',arg=>undef,@_);
}


##======================================================================
package DDC::Query::Filter::HasField;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter);
sub new {
  my $that = shift;
  return $that->SUPER::new(name=>'#HAS_FIELD',field=>undef,value=>undef,@_);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return "#HAS_FIELD[".escapeq($qf->{field}).','.escapeq($qf->{value}).']';
}

##======================================================================
## HasFieldRegex
##  + value is assumed to be pre-quoted and escaped!
package DDC::Query::Filter::HasFieldRegex;
use DDC::Utils qw(:escape);
our @ISA = qw(DDC::Query::Filter::HasField);

sub new {
  my ($that,%args) = @_;
  return $that->SUPER::new(%args);
}

## $str = $qf->toString()
sub toString {
  my $qf = shift;
  return "#HAS_FIELD[".escapeq($qf->{field}).','.$qf->{value}.']';
}

1; ##-- be happy
